/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.protocol.rest.AuthorizationPatchRequest;
import io.camunda.zeebe.gateway.protocol.rest.AuthorizationPatchRequestPermissionsInner;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ProblemDetail;

public final class AuthorizationRequestValidator {
    public static Optional<ProblemDetail> validateAuthorizationAssignRequest(AuthorizationPatchRequest authorizationPatchRequest) {
        ArrayList<String> violations = new ArrayList<String>();
        if (authorizationPatchRequest.getAction() == null) {
            violations.add("No %s provided".formatted("action"));
        }
        if (authorizationPatchRequest.getResourceType() == null) {
            violations.add("No %s provided".formatted("resourceType"));
        }
        if (authorizationPatchRequest.getPermissions() == null || authorizationPatchRequest.getPermissions().isEmpty()) {
            violations.add("No %s provided".formatted("permissions"));
        } else {
            authorizationPatchRequest.getPermissions().forEach(permission -> AuthorizationRequestValidator.validatePermission(permission, violations));
        }
        return RequestValidator.createProblemDetail(violations);
    }

    private static void validatePermission(AuthorizationPatchRequestPermissionsInner permission, List<String> violations) {
        if (permission.getPermissionType() == null) {
            violations.add("No %s provided".formatted("permissionType"));
        } else if (permission.getResourceIds() == null || permission.getResourceIds().isEmpty()) {
            violations.add("No %s provided in '%s'".formatted(new Object[]{"resourceIds", permission.getPermissionType()}));
        }
    }
}

