/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.impl.filters;

import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.configuration.FilterCfg;
import io.camunda.zeebe.gateway.rest.impl.filters.FilterLoadException;
import io.camunda.zeebe.util.ReflectUtil;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import io.camunda.zeebe.util.jar.ExternalJarRepository;
import jakarta.servlet.Filter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.slf4j.Logger;

public final class FilterRepository {
    private static final Logger LOGGER = Loggers.GATEWAY_LOGGER;
    private final ExternalJarRepository jarRepository;
    private final Map<String, Class<? extends Filter>> filters;
    private final Path basePath;

    public FilterRepository() {
        this(new LinkedHashMap<String, Class<? extends Filter>>(), new ExternalJarRepository(), Paths.get(Optional.ofNullable(System.getProperty("basedir")).orElse("."), new String[0]));
    }

    public FilterRepository(Map<String, Class<? extends Filter>> filters, ExternalJarRepository jarRepository, Path basePath) {
        this.filters = filters;
        this.jarRepository = jarRepository;
        this.basePath = basePath;
    }

    public Map<String, Class<? extends Filter>> getFilters() {
        return this.filters;
    }

    public Stream<Filter> instantiate() {
        return this.filters.entrySet().stream().map(entry -> this.instantiate((String)entry.getKey(), (Class)entry.getValue()));
    }

    public FilterRepository load(List<? extends FilterCfg> configs) {
        configs.forEach(config -> {
            try {
                this.load((FilterCfg)config);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to load filter {} with config {}", (Object)config.getId(), config);
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        });
        return this;
    }

    public Class<? extends Filter> load(FilterCfg config) throws ExternalJarLoadException {
        Class<Filter> filterClass;
        ClassLoader classLoader;
        String id = config.getId();
        if (this.filters.containsKey(id)) {
            return this.filters.get(id);
        }
        if (!config.isExternal()) {
            classLoader = this.getClass().getClassLoader();
        } else {
            Path jarPath = this.basePath.resolve(config.getJarPath());
            classLoader = this.jarRepository.load(jarPath);
        }
        try {
            Class<?> specifiedClass = classLoader.loadClass(config.getClassName());
            filterClass = specifiedClass.asSubclass(Filter.class);
        }
        catch (ClassNotFoundException e) {
            throw new FilterLoadException(id, "cannot load specified class", e);
        }
        catch (ClassCastException e) {
            throw new FilterLoadException(id, "specified class does not implement Filter", e);
        }
        this.filters.put(id, filterClass);
        return filterClass;
    }

    private Filter instantiate(String id, Class<? extends Filter> filterClass) {
        try {
            return (Filter)ReflectUtil.newInstance(filterClass);
        }
        catch (Exception e) {
            throw new FilterLoadException(id, "cannot instantiate via the default constructor", e);
        }
    }
}

