/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller.usermanagement;

import io.camunda.service.UserServices;
import io.camunda.service.entities.UserEntity;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.search.query.UserQuery;
import io.camunda.zeebe.gateway.protocol.rest.UserSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserSearchResponse;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryRequestMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryResponseMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestQueryController;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestQueryController
@RequestMapping(value={"/v2/users"})
public class UserQueryController {
    private final UserServices userServices;

    public UserQueryController(UserServices userServices) {
        this.userServices = userServices;
    }

    @PostMapping(path={"/search"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public ResponseEntity<UserSearchResponse> searchUsers(@RequestBody(required=false) UserSearchQueryRequest query) {
        return (ResponseEntity)SearchQueryRequestMapper.toUserQuery(query).fold(RestErrorMapper::mapProblemToResponse, this::search);
    }

    private ResponseEntity<UserSearchResponse> search(UserQuery query) {
        try {
            SearchQueryResult result = this.userServices.search(query);
            return ResponseEntity.ok((Object)SearchQueryResponseMapper.toUserSearchQueryResponse((SearchQueryResult<UserEntity>)result));
        }
        catch (Throwable e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage(), "Failed to execute User Search Query");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }
}

