/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.UserTaskServices;
import io.camunda.service.entities.UserTaskEntity;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.search.query.UserTaskQuery;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskSearchQueryRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryRequestMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryResponseMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestQueryController;
import jakarta.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestQueryController
@RequestMapping(value={"/v2/user-tasks"})
public class UserTaskQueryController {
    @Autowired
    private UserTaskServices userTaskServices;

    @PostMapping(path={"/search"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public ResponseEntity<Object> searchUserTasks(@RequestBody(required=false) UserTaskSearchQueryRequest query) {
        return (ResponseEntity)SearchQueryRequestMapper.toUserTaskQuery(query).fold(RestErrorMapper::mapProblemToResponse, this::search);
    }

    private ResponseEntity<Object> search(UserTaskQuery query) {
        try {
            SearchQueryResult result = this.userTaskServices.withAuthentication(RequestMapper.getAuthentication()).search(query);
            return ResponseEntity.ok((Object)SearchQueryResponseMapper.toUserTaskSearchQueryResponse((SearchQueryResult<UserTaskEntity>)result));
        }
        catch (ValidationException e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage(), "Validation failed for UserTask Search Query");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
        catch (Exception e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), "Failed to execute UserTask Search Query");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }
}

