/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.UserTaskServices;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskAssignmentRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskCompletionRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskUpdateRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(path={"/v1/user-tasks", "/v2/user-tasks"})
public class UserTaskController {
    private final UserTaskServices userTaskServices;

    @Autowired
    public UserTaskController(UserTaskServices userTaskServices) {
        this.userTaskServices = userTaskServices;
    }

    @PostMapping(path={"/{userTaskKey}/completion"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> completeUserTask(@PathVariable long userTaskKey, @RequestBody(required=false) UserTaskCompletionRequest completionRequest) {
        return this.completeUserTask(RequestMapper.toUserTaskCompletionRequest(completionRequest, userTaskKey));
    }

    @PostMapping(path={"/{userTaskKey}/assignment"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> assignUserTask(@PathVariable long userTaskKey, @RequestBody UserTaskAssignmentRequest assignmentRequest) {
        return (CompletableFuture)RequestMapper.toUserTaskAssignmentRequest(assignmentRequest, userTaskKey).fold(RestErrorMapper::mapProblemToCompletedResponse, this::assignUserTask);
    }

    @DeleteMapping(path={"/{userTaskKey}/assignee"})
    public CompletableFuture<ResponseEntity<Object>> unassignUserTask(@PathVariable long userTaskKey) {
        return this.unassignUserTask(RequestMapper.toUserTaskUnassignmentRequest(userTaskKey));
    }

    @PatchMapping(path={"/{userTaskKey}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> updateUserTask(@PathVariable long userTaskKey, @RequestBody(required=false) UserTaskUpdateRequest updateRequest) {
        return (CompletableFuture)RequestMapper.toUserTaskUpdateRequest(updateRequest, userTaskKey).fold(RestErrorMapper::mapProblemToCompletedResponse, this::updateUserTask);
    }

    private CompletableFuture<ResponseEntity<Object>> assignUserTask(RequestMapper.AssignUserTaskRequest request) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.userTaskServices.withAuthentication(RequestMapper.getAuthentication()).assignUserTask(request.userTaskKey(), request.assignee(), request.action(), request.allowOverride()));
    }

    private CompletableFuture<ResponseEntity<Object>> completeUserTask(RequestMapper.CompleteUserTaskRequest request) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.userTaskServices.withAuthentication(RequestMapper.getAuthentication()).completeUserTask(request.userTaskKey(), request.variables(), request.action()));
    }

    private CompletableFuture<ResponseEntity<Object>> unassignUserTask(RequestMapper.AssignUserTaskRequest request) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.userTaskServices.withAuthentication(RequestMapper.getAuthentication()).unassignUserTask(request.userTaskKey(), request.action()));
    }

    private CompletableFuture<ResponseEntity<Object>> updateUserTask(RequestMapper.UpdateUserTaskRequest request) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.userTaskServices.withAuthentication(RequestMapper.getAuthentication()).updateUserTask(request.userTaskKey(), request.changeset(), request.action()));
    }
}

