/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.atomix.utils.net.Address;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.gateway.protocol.rest.BrokerInfo;
import io.camunda.zeebe.gateway.protocol.rest.Partition;
import io.camunda.zeebe.gateway.protocol.rest.TopologyResponse;
import io.camunda.zeebe.gateway.rest.Loggers;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;
import io.camunda.zeebe.util.VersionUtil;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(path={"/v1", "/v2"})
public final class TopologyController {
    private final BrokerClient client;

    @Autowired
    public TopologyController(BrokerClient client) {
        this.client = client;
    }

    @GetMapping(path={"/topology"}, produces={"application/json"})
    public TopologyResponse get() {
        TopologyResponse response = new TopologyResponse();
        BrokerClusterState topology = this.client.getTopologyManager().getTopology();
        String gatewayVersion = VersionUtil.getVersion();
        if (gatewayVersion != null && !gatewayVersion.isBlank()) {
            response.gatewayVersion(gatewayVersion);
        }
        if (topology != null) {
            response.clusterSize(topology.getClusterSize()).partitionsCount(topology.getPartitionsCount()).replicationFactor(topology.getReplicationFactor());
            topology.getBrokers().forEach(brokerId -> {
                BrokerInfo brokerInfo = new BrokerInfo();
                this.addBrokerInfo(brokerInfo, (Integer)brokerId, topology);
                this.addPartitionInfoToBrokerInfo(brokerInfo, (Integer)brokerId, topology);
                response.addBrokersItem(brokerInfo);
            });
        }
        return response;
    }

    private void addBrokerInfo(BrokerInfo brokerInfo, Integer brokerId, BrokerClusterState topology) {
        String brokerAddress = topology.getBrokerAddress(brokerId.intValue());
        Address address = Address.from((String)brokerAddress);
        brokerInfo.setNodeId(brokerId);
        brokerInfo.setHost(address.host());
        brokerInfo.setPort(address.port());
        brokerInfo.setVersion(topology.getBrokerVersion(brokerId.intValue()));
    }

    private void addPartitionInfoToBrokerInfo(BrokerInfo brokerInfo, Integer brokerId, BrokerClusterState topology) {
        topology.getPartitions().forEach(partitionId -> {
            Partition partition = new Partition();
            partition.setPartitionId((Integer)partitionId);
            boolean isRoleSet = this.setRole(brokerId, (Integer)partitionId, topology, partition);
            if (!isRoleSet) {
                return;
            }
            PartitionHealthStatus status = topology.getPartitionHealth(brokerId.intValue(), partitionId.intValue());
            switch (status) {
                case HEALTHY: {
                    partition.setHealth(Partition.HealthEnum.HEALTHY);
                    break;
                }
                case UNHEALTHY: {
                    partition.setHealth(Partition.HealthEnum.UNHEALTHY);
                    break;
                }
                case DEAD: {
                    partition.setHealth(Partition.HealthEnum.DEAD);
                    break;
                }
                default: {
                    Loggers.REST_LOGGER.debug("Unsupported partition broker health status '{}'", (Object)status.name());
                }
            }
            brokerInfo.addPartitionsItem(partition);
        });
    }

    private boolean setRole(Integer brokerId, Integer partitionId, BrokerClusterState topology, Partition partition) {
        int partitionLeader = topology.getLeaderForPartition(partitionId.intValue());
        Set partitionFollowers = topology.getFollowersForPartition(partitionId.intValue());
        Set partitionInactives = topology.getInactiveNodesForPartition(partitionId.intValue());
        if (partitionLeader == brokerId) {
            partition.setRole(Partition.RoleEnum.LEADER);
        } else if (partitionFollowers != null && partitionFollowers.contains(brokerId)) {
            partition.setRole(Partition.RoleEnum.FOLLOWER);
        } else if (partitionInactives != null && partitionInactives.contains(brokerId)) {
            partition.setRole(Partition.RoleEnum.INACTIVE);
        } else {
            return false;
        }
        return true;
    }
}

