/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.SignalServices;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import io.camunda.zeebe.gateway.protocol.rest.SignalBroadcastRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.ResponseMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(value={"/v2/signals"})
public class SignalController {
    private final SignalServices signalServices;
    private final MultiTenancyCfg multiTenancyCfg;

    @Autowired
    public SignalController(SignalServices signalServices, MultiTenancyCfg multiTenancyCfg) {
        this.signalServices = signalServices;
        this.multiTenancyCfg = multiTenancyCfg;
    }

    @PostMapping(path={"/broadcast"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> broadcastSignal(@RequestBody SignalBroadcastRequest request) {
        return (CompletableFuture)RequestMapper.toBroadcastSignalRequest(request, this.multiTenancyCfg.isEnabled()).fold(RestErrorMapper::mapProblemToCompletedResponse, this::broadcastSignal);
    }

    private CompletableFuture<ResponseEntity<Object>> broadcastSignal(RequestMapper.BroadcastSignalRequest request) {
        return RequestMapper.executeServiceMethod(() -> this.signalServices.withAuthentication(RequestMapper.getAuthentication()).broadcastSignal(request.signalName(), request.variables(), request.tenantId()), ResponseMapper::toSignalBroadcastResponse);
    }
}

