/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.ResourceServices;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import io.camunda.zeebe.gateway.protocol.rest.DeleteResourceRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.ResponseMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@CamundaRestController
@RequestMapping(value={"/v2"})
public class ResourceController {
    private final ResourceServices resourceServices;
    private final MultiTenancyCfg multiTenancyCfg;

    @Autowired
    public ResourceController(ResourceServices resourceServices, MultiTenancyCfg multiTenancyCfg) {
        this.resourceServices = resourceServices;
        this.multiTenancyCfg = multiTenancyCfg;
    }

    @PostMapping(path={"/deployments"}, consumes={"multipart/form-data"}, produces={"application/json", "application/problem+json"})
    public CompletableFuture<ResponseEntity<Object>> deployResources(@RequestPart(value="resources") List<MultipartFile> resources, @RequestPart(value="tenantId", required=false) String tenantId) {
        return (CompletableFuture)RequestMapper.toDeployResourceRequest(resources, tenantId, this.multiTenancyCfg.isEnabled()).fold(RestErrorMapper::mapProblemToCompletedResponse, this::deployResources);
    }

    @PostMapping(path={"/resources/{resourceKey}/deletion"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> deleteResource(@PathVariable long resourceKey, @RequestBody(required=false) DeleteResourceRequest deleteRequest) {
        return (CompletableFuture)RequestMapper.toResourceDeletion(resourceKey, deleteRequest).fold(RestErrorMapper::mapProblemToCompletedResponse, this::delete);
    }

    private CompletableFuture<ResponseEntity<Object>> deployResources(ResourceServices.DeployResourcesRequest request) {
        return RequestMapper.executeServiceMethod(() -> this.resourceServices.withAuthentication(RequestMapper.getAuthentication()).deployResources(request), ResponseMapper::toDeployResourceResponse);
    }

    private CompletableFuture<ResponseEntity<Object>> delete(ResourceServices.ResourceDeletionRequest request) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.resourceServices.withAuthentication(RequestMapper.getAuthentication()).deleteResource(request));
    }
}

