/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.ProcessInstanceServices;
import io.camunda.service.entities.ProcessInstanceEntity;
import io.camunda.service.search.query.ProcessInstanceQuery;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceSearchQueryResponse;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryRequestMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryResponseMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestQueryController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestQueryController
@RequestMapping(value={"/v2/process-instances"})
public class ProcessInstanceQueryController {
    @Autowired
    private ProcessInstanceServices processInstanceServices;

    @PostMapping(path={"/search"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public ResponseEntity<ProcessInstanceSearchQueryResponse> searchProcessInstances(@RequestBody(required=false) ProcessInstanceSearchQueryRequest query) {
        return (ResponseEntity)SearchQueryRequestMapper.toProcessInstanceQuery(query).fold(RestErrorMapper::mapProblemToResponse, this::search);
    }

    private ResponseEntity<ProcessInstanceSearchQueryResponse> search(ProcessInstanceQuery query) {
        try {
            SearchQueryResult result = this.processInstanceServices.withAuthentication(RequestMapper.getAuthentication()).search(query);
            return ResponseEntity.ok((Object)SearchQueryResponseMapper.toProcessInstanceSearchQueryResponse((SearchQueryResult<ProcessInstanceEntity>)result));
        }
        catch (Throwable e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage(), "Failed to execute Process Instance Search Query");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }
}

