/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.ProcessInstanceServices;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import io.camunda.zeebe.gateway.protocol.rest.CancelProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.CreateProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.MigrateProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.ResponseMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(value={"/v2/process-instances"})
public class ProcessInstanceController {
    private final ProcessInstanceServices processInstanceServices;
    private final MultiTenancyCfg multiTenancyCfg;

    @Autowired
    public ProcessInstanceController(ProcessInstanceServices processInstanceServices, MultiTenancyCfg multiTenancyCfg) {
        this.processInstanceServices = processInstanceServices;
        this.multiTenancyCfg = multiTenancyCfg;
    }

    @PostMapping(produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> createProcessInstance(@RequestBody CreateProcessInstanceRequest request) {
        return (CompletableFuture)RequestMapper.toCreateProcessInstance(request, this.multiTenancyCfg.isEnabled()).fold(RestErrorMapper::mapProblemToCompletedResponse, this::createProcessInstance);
    }

    @PostMapping(path={"/{processInstanceKey}/cancellation"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> cancelProcessInstance(@PathVariable long processInstanceKey, @RequestBody(required=false) CancelProcessInstanceRequest cancelRequest) {
        return (CompletableFuture)RequestMapper.toCancelProcessInstance(processInstanceKey, cancelRequest).fold(RestErrorMapper::mapProblemToCompletedResponse, this::cancelProcessInstance);
    }

    @PostMapping(path={"/{processInstanceKey}/migration"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> migrateProcessInstance(@PathVariable long processInstanceKey, @RequestBody MigrateProcessInstanceRequest migrationRequest) {
        return (CompletableFuture)RequestMapper.toMigrateProcessInstance(processInstanceKey, migrationRequest).fold(RestErrorMapper::mapProblemToCompletedResponse, this::migrateProcessInstance);
    }

    @PostMapping(path={"/{processInstanceKey}/modification"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> modifyProcessInstance(@PathVariable long processInstanceKey, @RequestBody ModifyProcessInstanceRequest modifyRequest) {
        return (CompletableFuture)RequestMapper.toModifyProcessInstance(processInstanceKey, modifyRequest).fold(RestErrorMapper::mapProblemToCompletedResponse, this::modifyProcessInstance);
    }

    private CompletableFuture<ResponseEntity<Object>> createProcessInstance(ProcessInstanceServices.ProcessInstanceCreateRequest request) {
        if (request.awaitCompletion().booleanValue()) {
            return RequestMapper.executeServiceMethod(() -> this.processInstanceServices.withAuthentication(RequestMapper.getAuthentication()).createProcessInstanceWithResult(request), ResponseMapper::toCreateProcessInstanceWithResultResponse);
        }
        return RequestMapper.executeServiceMethod(() -> this.processInstanceServices.withAuthentication(RequestMapper.getAuthentication()).createProcessInstance(request), ResponseMapper::toCreateProcessInstanceResponse);
    }

    private CompletableFuture<ResponseEntity<Object>> cancelProcessInstance(ProcessInstanceServices.ProcessInstanceCancelRequest request) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.processInstanceServices.withAuthentication(RequestMapper.getAuthentication()).cancelProcessInstance(request));
    }

    private CompletableFuture<ResponseEntity<Object>> migrateProcessInstance(ProcessInstanceServices.ProcessInstanceMigrateRequest request) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.processInstanceServices.withAuthentication(RequestMapper.getAuthentication()).migrateProcessInstance(request));
    }

    private CompletableFuture<ResponseEntity<Object>> modifyProcessInstance(ProcessInstanceServices.ProcessInstanceModifyRequest request) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.processInstanceServices.withAuthentication(RequestMapper.getAuthentication()).modifyProcessInstance(request));
    }
}

