/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.MessageServices;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import io.camunda.zeebe.gateway.protocol.rest.MessageCorrelationRequest;
import io.camunda.zeebe.gateway.protocol.rest.MessagePublicationRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.ResponseMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(value={"/v2/messages"})
public class MessageController {
    private final MessageServices messageServices;
    private final MultiTenancyCfg multiTenancyCfg;

    @Autowired
    public MessageController(MessageServices messageServices, MultiTenancyCfg multiTenancyCfg) {
        this.messageServices = messageServices;
        this.multiTenancyCfg = multiTenancyCfg;
    }

    @PostMapping(path={"/publication"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> publishMessage(@RequestBody MessagePublicationRequest publicationRequest) {
        return (CompletableFuture)RequestMapper.toMessagePublicationRequest(publicationRequest, this.multiTenancyCfg.isEnabled()).fold(RestErrorMapper::mapProblemToCompletedResponse, this::publishMessage);
    }

    @PostMapping(path={"/correlation"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> correlateMessage(@RequestBody MessageCorrelationRequest correlationRequest) {
        return (CompletableFuture)RequestMapper.toMessageCorrelationRequest(correlationRequest, this.multiTenancyCfg.isEnabled()).fold(RestErrorMapper::mapProblemToCompletedResponse, this::correlateMessage);
    }

    private CompletableFuture<ResponseEntity<Object>> correlateMessage(MessageServices.CorrelateMessageRequest correlationRequest) {
        return RequestMapper.executeServiceMethod(() -> this.messageServices.withAuthentication(RequestMapper.getAuthentication()).correlateMessage(correlationRequest), ResponseMapper::toMessageCorrelationResponse);
    }

    private CompletableFuture<ResponseEntity<Object>> publishMessage(MessageServices.PublicationMessageRequest request) {
        return RequestMapper.executeServiceMethod(() -> this.messageServices.withAuthentication(RequestMapper.getAuthentication()).publishMessage(request), ResponseMapper::toMessagePublicationResponse);
    }
}

