/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.JobServices;
import io.camunda.zeebe.gateway.impl.job.ResponseObserver;
import io.camunda.zeebe.gateway.protocol.rest.JobActivationRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobActivationResponse;
import io.camunda.zeebe.gateway.protocol.rest.JobCompletionRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobErrorRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobFailRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobUpdateRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import io.camunda.zeebe.gateway.rest.controller.JobActivationRequestResponseObserver;
import io.camunda.zeebe.gateway.rest.controller.ResponseObserverProvider;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(value={"/v2/jobs"})
public class JobController {
    private final ResponseObserverProvider responseObserverProvider;
    private final JobServices<JobActivationResponse> jobServices;

    @Autowired
    public JobController(JobServices<JobActivationResponse> jobServices, ResponseObserverProvider responseObserverProvider) {
        this.jobServices = jobServices;
        this.responseObserverProvider = responseObserverProvider;
    }

    @PostMapping(path={"/activation"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> activateJobs(@RequestBody JobActivationRequest activationRequest) {
        return (CompletableFuture)RequestMapper.toJobsActivationRequest(activationRequest).fold(RestErrorMapper::mapProblemToCompletedResponse, this::activateJobs);
    }

    @PostMapping(path={"/{jobKey}/failure"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> failureJob(@PathVariable long jobKey, @RequestBody(required=false) JobFailRequest failureRequest) {
        return this.failJob(RequestMapper.toJobFailRequest(failureRequest, jobKey));
    }

    @PostMapping(path={"/{jobKey}/error"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> errorJob(@PathVariable long jobKey, @RequestBody JobErrorRequest errorRequest) {
        return (CompletableFuture)RequestMapper.toJobErrorRequest(errorRequest, jobKey).fold(RestErrorMapper::mapProblemToCompletedResponse, this::errorJob);
    }

    @PostMapping(path={"/{jobKey}/completion"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> completeJob(@PathVariable long jobKey, @RequestBody(required=false) JobCompletionRequest completionRequest) {
        return this.completeJob(RequestMapper.toJobCompletionRequest(completionRequest, jobKey));
    }

    @PatchMapping(path={"/{jobKey}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> updateJob(@PathVariable long jobKey, @RequestBody JobUpdateRequest jobUpdateRequest) {
        return (CompletableFuture)RequestMapper.toJobUpdateRequest(jobUpdateRequest, jobKey).fold(RestErrorMapper::mapProblemToCompletedResponse, this::updateJob);
    }

    private CompletableFuture<ResponseEntity<Object>> activateJobs(JobServices.ActivateJobsRequest activationRequest) {
        CompletableFuture result = new CompletableFuture();
        JobActivationRequestResponseObserver responseObserver = (JobActivationRequestResponseObserver)this.responseObserverProvider.apply(result);
        this.jobServices.activateJobs(activationRequest, (ResponseObserver)responseObserver, responseObserver::setCancelationHandler);
        return result.handleAsync((res, ex) -> {
            responseObserver.invokeCancelationHandler();
            return res;
        });
    }

    private CompletableFuture<ResponseEntity<Object>> failJob(RequestMapper.FailJobRequest failJobRequest) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.jobServices.withAuthentication(RequestMapper.getAuthentication()).failJob(failJobRequest.jobKey(), failJobRequest.retries(), failJobRequest.errorMessage(), failJobRequest.retryBackoff(), failJobRequest.variables()));
    }

    private CompletableFuture<ResponseEntity<Object>> errorJob(RequestMapper.ErrorJobRequest errorJobRequest) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.jobServices.withAuthentication(RequestMapper.getAuthentication()).errorJob(errorJobRequest.jobKey(), errorJobRequest.errorCode(), errorJobRequest.errorMessage(), errorJobRequest.variables()));
    }

    private CompletableFuture<ResponseEntity<Object>> completeJob(RequestMapper.CompleteJobRequest completeJobRequest) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.jobServices.withAuthentication(RequestMapper.getAuthentication()).completeJob(completeJobRequest.jobKey(), completeJobRequest.variables()));
    }

    private CompletableFuture<ResponseEntity<Object>> updateJob(RequestMapper.UpdateJobRequest updateJobRequest) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.jobServices.withAuthentication(RequestMapper.getAuthentication()).updateJob(updateJobRequest.jobKey(), updateJobRequest.changeset()));
    }
}

