/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.zeebe.gateway.impl.job.ResponseObserver;
import io.camunda.zeebe.gateway.protocol.rest.JobActivationResponse;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.ResponseEntity;

public class JobActivationRequestResponseObserver
implements ResponseObserver<JobActivationResponse> {
    protected JobActivationResponse response = new JobActivationResponse();
    protected CompletableFuture<ResponseEntity<Object>> result;
    private Runnable cancelationHandler;

    public JobActivationRequestResponseObserver(CompletableFuture<ResponseEntity<Object>> result) {
        this.result = result;
    }

    public void onCompleted() {
        this.result.complete((ResponseEntity<Object>)ResponseEntity.ok((Object)this.response));
    }

    public void onNext(JobActivationResponse element) {
        if (element.getJobs() != null && !element.getJobs().isEmpty()) {
            element.getJobs().forEach(this.response::addJobsItem);
        }
    }

    public boolean isCancelled() {
        return this.result.isCancelled() || this.result.isCompletedExceptionally();
    }

    public void onError(Throwable throwable) {
        this.result.complete(RestErrorMapper.mapProblemToResponse(RestErrorMapper.mapErrorToProblem(throwable, RestErrorMapper.DEFAULT_REJECTION_MAPPER)));
    }

    public void setCancelationHandler(Runnable handler) {
        this.cancelationHandler = handler;
    }

    public void invokeCancelationHandler() {
        if (this.cancelationHandler != null) {
            this.cancelationHandler.run();
        }
    }
}

