/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.IncidentServices;
import io.camunda.service.entities.IncidentEntity;
import io.camunda.service.exception.NotFoundException;
import io.camunda.service.search.query.IncidentQuery;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.zeebe.gateway.protocol.rest.IncidentItem;
import io.camunda.zeebe.gateway.protocol.rest.IncidentSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.IncidentSearchQueryResponse;
import io.camunda.zeebe.gateway.rest.Loggers;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryRequestMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryResponseMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestQueryController;
import io.camunda.zeebe.protocol.record.RejectionType;
import jakarta.validation.ValidationException;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestQueryController
@RequestMapping(value={"/v2/incidents"})
public class IncidentQueryController {
    private final IncidentServices incidentServices;

    public IncidentQueryController(IncidentServices incidentServices) {
        this.incidentServices = incidentServices;
    }

    @PostMapping(path={"/search"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public ResponseEntity<IncidentSearchQueryResponse> searchIncidents(@RequestBody(required=false) IncidentSearchQueryRequest query) {
        return (ResponseEntity)SearchQueryRequestMapper.toIncidentQuery(query).fold(RestErrorMapper::mapProblemToResponse, this::search);
    }

    @GetMapping(path={"/{incidentKey}"}, produces={"application/json", "application/problem+json"})
    public ResponseEntity<IncidentItem> getByKey(@PathVariable(value="incidentKey") Long incidentKey) {
        try {
            return ResponseEntity.ok().contentType(new MediaType(MediaType.APPLICATION_JSON, StandardCharsets.UTF_8)).body((Object)SearchQueryResponseMapper.toIncident(this.incidentServices.getByKey(incidentKey)));
        }
        catch (NotFoundException nfe) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.NOT_FOUND, nfe.getMessage(), RejectionType.NOT_FOUND.name());
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
        catch (Exception e) {
            Loggers.REST_LOGGER.warn("An exception occurred in get incident by key.", (Throwable)e);
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), "Failed to execute Get Incident by key.");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }

    private ResponseEntity<IncidentSearchQueryResponse> search(IncidentQuery query) {
        try {
            SearchQueryResult result = this.incidentServices.withAuthentication(RequestMapper.getAuthentication()).search(query);
            return ResponseEntity.ok((Object)SearchQueryResponseMapper.toIncidentSearchQueryResponse((SearchQueryResult<IncidentEntity>)result));
        }
        catch (ValidationException e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage(), "Validation failed for Incident Search Query");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
        catch (Exception e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), "Failed to execute Incident Search Query");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }
}

