/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.IncidentServices;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(value={"v2/incidents"})
public class IncidentController {
    private final IncidentServices incidentServices;

    @Autowired
    public IncidentController(IncidentServices incidentServices) {
        this.incidentServices = incidentServices;
    }

    @PostMapping(path={"/{incidentKey}/resolution"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> incidentResolution(@PathVariable long incidentKey) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.incidentServices.withAuthentication(RequestMapper.getAuthentication()).resolveIncident(incidentKey));
    }
}

