/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.FlowNodeInstanceServices;
import io.camunda.service.entities.FlowNodeInstanceEntity;
import io.camunda.service.search.query.FlowNodeInstanceQuery;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.zeebe.gateway.protocol.rest.FlowNodeInstanceSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.FlowNodeInstanceSearchQueryResponse;
import io.camunda.zeebe.gateway.rest.Loggers;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryRequestMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryResponseMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestQueryController;
import jakarta.validation.ValidationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestQueryController
@RequestMapping(value={"/v2/flownode-instances"})
public class FlowNodeInstanceQueryController {
    private final FlowNodeInstanceServices flownodeInstanceServices;

    public FlowNodeInstanceQueryController(FlowNodeInstanceServices flownodeInstanceServices) {
        this.flownodeInstanceServices = flownodeInstanceServices;
    }

    @PostMapping(path={"/search"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public ResponseEntity<FlowNodeInstanceSearchQueryResponse> searchFlownodeInstances(@RequestBody(required=false) FlowNodeInstanceSearchQueryRequest query) {
        return (ResponseEntity)SearchQueryRequestMapper.toFlownodeInstanceQuery(query).fold(RestErrorMapper::mapProblemToResponse, this::search);
    }

    private ResponseEntity<FlowNodeInstanceSearchQueryResponse> search(FlowNodeInstanceQuery query) {
        try {
            SearchQueryResult result = this.flownodeInstanceServices.withAuthentication(RequestMapper.getAuthentication()).search(query);
            return ResponseEntity.ok((Object)SearchQueryResponseMapper.toFlownodeInstanceSearchQueryResponse((SearchQueryResult<FlowNodeInstanceEntity>)result));
        }
        catch (ValidationException e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage(), "Validation failed for Flownode Instance Search Query");
            Loggers.REST_LOGGER.warn("An exception occurred in searchFlowNodeInstances.", (Throwable)e);
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
        catch (Throwable e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), "Failed to execute Flownode Instance Search Query");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }
}

