/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.ElementInstanceServices;
import io.camunda.zeebe.gateway.protocol.rest.SetVariableRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(value={"/v2/element-instances"})
public class ElementInstanceController {
    private final ElementInstanceServices elementInstanceServices;

    @Autowired
    public ElementInstanceController(ElementInstanceServices elementInstanceServices) {
        this.elementInstanceServices = elementInstanceServices;
    }

    @PutMapping(path={"/{elementInstanceKey}/variables"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> setVariables(@PathVariable long elementInstanceKey, @RequestBody SetVariableRequest variableRequest) {
        return (CompletableFuture)RequestMapper.toVariableRequest(variableRequest, elementInstanceKey).fold(RestErrorMapper::mapProblemToCompletedResponse, this::setVariables);
    }

    private CompletableFuture<ResponseEntity<Object>> setVariables(ElementInstanceServices.SetVariablesRequest variablesRequest) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.elementInstanceServices.withAuthentication(RequestMapper.getAuthentication()).setVariables(variablesRequest));
    }
}

