/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.DocumentServices;
import io.camunda.zeebe.gateway.protocol.rest.DocumentLinkRequest;
import io.camunda.zeebe.gateway.protocol.rest.DocumentMetadata;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.ResponseMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@CamundaRestController
@RequestMapping(value={"/v2/documents"})
public class DocumentController {
    private final DocumentServices documentServices;

    @Autowired
    public DocumentController(DocumentServices documentServices) {
        this.documentServices = documentServices;
    }

    @PostMapping(consumes={"multipart/form-data"}, produces={"application/json", "application/problem+json"})
    public CompletableFuture<ResponseEntity<Object>> createDocument(@RequestParam(required=false) String documentId, @RequestParam(required=false) String storeId, @RequestPart(value="file") MultipartFile file, @RequestPart(value="metadata", required=false) DocumentMetadata metadata) {
        return (CompletableFuture)RequestMapper.toDocumentCreateRequest(documentId, storeId, file, metadata).fold(RestErrorMapper::mapProblemToCompletedResponse, this::createDocument);
    }

    private CompletableFuture<ResponseEntity<Object>> createDocument(DocumentServices.DocumentCreateRequest request) {
        return RequestMapper.executeServiceMethod(() -> this.documentServices.withAuthentication(RequestMapper.getAuthentication()).createDocument(request), ResponseMapper::toDocumentReference);
    }

    @GetMapping(path={"/{documentId}"}, produces={"application/octet-stream", "application/problem+json"})
    public ResponseEntity<StreamingResponseBody> getDocumentContent(@PathVariable String documentId, @RequestParam(required=false) String storeId) {
        try {
            InputStream contentInputStream = this.getDocumentContentStream(documentId, storeId);
            return ResponseEntity.ok().body(contentInputStream::transferTo);
        }
        catch (Exception e) {
            if (e instanceof CompletionException) {
                CompletionException ce = (CompletionException)e;
                throw new DocumentContentFetchException("Failed to get document content", ce.getCause());
            }
            throw new DocumentContentFetchException("Failed to get document content", e);
        }
    }

    @ExceptionHandler(value={DocumentContentFetchException.class})
    public ResponseEntity<Object> handleDocumentContentException(DocumentContentFetchException e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof DocumentServices.DocumentException) {
            DocumentServices.DocumentException de = (DocumentServices.DocumentException)throwable;
            return RestErrorMapper.mapDocumentHandlingExceptionToResponse(de);
        }
        return RestErrorMapper.mapProblemToResponse(RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), e.getClass().getName()));
    }

    private InputStream getDocumentContentStream(String documentId, String storeId) {
        return this.documentServices.withAuthentication(RequestMapper.getAuthentication()).getDocumentContent(documentId, storeId);
    }

    @DeleteMapping(path={"/{documentId}"}, produces={"application/json", "application/problem+json"})
    public CompletableFuture<ResponseEntity<Object>> deleteDocument(@PathVariable String documentId, @RequestParam(required=false) String storeId) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.documentServices.withAuthentication(RequestMapper.getAuthentication()).deleteDocument(documentId, storeId));
    }

    @PostMapping(path={"/{documentId}/links"}, consumes={"application/json"}, produces={"application/json", "application/problem+json"})
    public ResponseEntity<Object> createDocumentLink(@PathVariable String documentId, @RequestParam(required=false) String storeId, @RequestBody DocumentLinkRequest linkRequest) {
        return (ResponseEntity)RequestMapper.toDocumentLinkParams(linkRequest).fold(RestErrorMapper::mapProblemToResponse, params -> (ResponseEntity)((CompletableFuture)this.documentServices.withAuthentication(RequestMapper.getAuthentication()).createLink(documentId, storeId, params).thenApply(ResponseMapper::toDocumentLinkResponse)).join());
    }

    public static class DocumentContentFetchException
    extends RuntimeException {
        public DocumentContentFetchException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

