/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.DecisionRequirementsServices;
import io.camunda.service.entities.DecisionRequirementsEntity;
import io.camunda.service.search.query.DecisionRequirementsQuery;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.zeebe.gateway.protocol.rest.DecisionRequirementsSearchQueryRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryRequestMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryResponseMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestQueryController;
import jakarta.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestQueryController
@RequestMapping(value={"/v2/decision-requirements"})
public class DecisionRequirementsQueryController {
    @Autowired
    private DecisionRequirementsServices decisionRequirementsServices;

    @PostMapping(path={"/search"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public ResponseEntity<Object> searchUserTasks(@RequestBody(required=false) DecisionRequirementsSearchQueryRequest query) {
        return (ResponseEntity)SearchQueryRequestMapper.toDecisionRequirementsQuery(query).fold(RestErrorMapper::mapProblemToResponse, this::search);
    }

    private ResponseEntity<Object> search(DecisionRequirementsQuery query) {
        try {
            SearchQueryResult result = this.decisionRequirementsServices.withAuthentication(RequestMapper.getAuthentication()).search(query);
            return ResponseEntity.ok((Object)SearchQueryResponseMapper.toDecisionRequirementsSearchQueryResponse((SearchQueryResult<DecisionRequirementsEntity>)result));
        }
        catch (ValidationException e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage(), "Validation failed for Decision Requirement Search Query");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
        catch (Exception e) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), "Failed to execute Decision Requirement Search Query");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }
}

