/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.DecisionInstanceServices;
import io.camunda.service.entities.DecisionInstanceEntity;
import io.camunda.service.search.query.DecisionInstanceQuery;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceSearchQueryResponse;
import io.camunda.zeebe.gateway.rest.Loggers;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryRequestMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryResponseMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestQueryController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestQueryController
@RequestMapping(value={"/v2/decision-instances"})
public class DecisionInstanceQueryController {
    @Autowired
    private DecisionInstanceServices decisionInstanceServices;

    @PostMapping(path={"/search"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public ResponseEntity<DecisionInstanceSearchQueryResponse> searchDecisionInstances(@RequestBody(required=false) DecisionInstanceSearchQueryRequest query) {
        return (ResponseEntity)SearchQueryRequestMapper.toDecisionInstanceQuery(query).fold(RestErrorMapper::mapProblemToResponse, this::search);
    }

    private ResponseEntity<DecisionInstanceSearchQueryResponse> search(DecisionInstanceQuery query) {
        try {
            SearchQueryResult decisionInstances = this.decisionInstanceServices.search(query);
            return ResponseEntity.ok((Object)SearchQueryResponseMapper.toDecisionInstanceSearchQueryResponse((SearchQueryResult<DecisionInstanceEntity>)decisionInstances));
        }
        catch (Exception e) {
            Loggers.REST_LOGGER.warn("An exception occurred in searchDecisionInstances.", (Throwable)e);
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), "Failed to execute Decision Instance Search Query.");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }
}

