/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.DecisionDefinitionServices;
import io.camunda.service.entities.DecisionDefinitionEntity;
import io.camunda.service.exception.NotFoundException;
import io.camunda.service.search.query.DecisionDefinitionQuery;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.zeebe.gateway.protocol.rest.DecisionDefinitionSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.DecisionDefinitionSearchQueryResponse;
import io.camunda.zeebe.gateway.rest.Loggers;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryRequestMapper;
import io.camunda.zeebe.gateway.rest.SearchQueryResponseMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestQueryController;
import io.camunda.zeebe.protocol.record.RejectionType;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestQueryController
@RequestMapping(value={"/v2/decision-definitions"})
public class DecisionDefinitionQueryController {
    @Autowired
    private DecisionDefinitionServices decisionDefinitionServices;

    @PostMapping(path={"/search"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public ResponseEntity<DecisionDefinitionSearchQueryResponse> searchDecisionDefinitions(@RequestBody(required=false) DecisionDefinitionSearchQueryRequest query) {
        return (ResponseEntity)SearchQueryRequestMapper.toDecisionDefinitionQuery(query).fold(RestErrorMapper::mapProblemToResponse, this::search);
    }

    @GetMapping(path={"/{decisionKey}/xml"}, produces={"text/xml", "application/problem+json"})
    public ResponseEntity<String> getDecisionDefinitionXml(@PathVariable(value="decisionKey") Long decisionKey) {
        try {
            return ResponseEntity.ok().contentType(new MediaType(MediaType.TEXT_XML, StandardCharsets.UTF_8)).body((Object)this.decisionDefinitionServices.getDecisionDefinitionXml(decisionKey));
        }
        catch (NotFoundException nfe) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.NOT_FOUND, nfe.getMessage(), RejectionType.NOT_FOUND.name());
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
        catch (Exception e) {
            Loggers.REST_LOGGER.warn("An exception occurred in getDecisionDefinitionXml.", (Throwable)e);
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), "Failed to execute Get Decision Definition XML Query.");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }

    private ResponseEntity<DecisionDefinitionSearchQueryResponse> search(DecisionDefinitionQuery query) {
        try {
            SearchQueryResult result = this.decisionDefinitionServices.withAuthentication(RequestMapper.getAuthentication()).search(query);
            return ResponseEntity.ok((Object)SearchQueryResponseMapper.toDecisionDefinitionSearchQueryResponse((SearchQueryResult<DecisionDefinitionEntity>)result));
        }
        catch (Exception e) {
            Loggers.REST_LOGGER.warn("An exception occurred in searchDecisionDefinitions.", (Throwable)e);
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), "Failed to execute Decision Definition Search Query.");
            return RestErrorMapper.mapProblemToResponse(problemDetail);
        }
    }
}

