/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.DecisionDefinitionServices;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import io.camunda.zeebe.gateway.protocol.rest.EvaluateDecisionRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.ResponseMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(value={"/v2/decision-definitions"})
public class DecisionDefinitionController {
    private final DecisionDefinitionServices decisionServices;
    private final MultiTenancyCfg multiTenancyCfg;

    @Autowired
    public DecisionDefinitionController(DecisionDefinitionServices decisionServices, MultiTenancyCfg multiTenancyCfg) {
        this.decisionServices = decisionServices;
        this.multiTenancyCfg = multiTenancyCfg;
    }

    @PostMapping(path={"/evaluation"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> evaluateDecision(@RequestBody EvaluateDecisionRequest evaluateDecisionRequest) {
        return (CompletableFuture)RequestMapper.toEvaluateDecisionRequest(evaluateDecisionRequest, this.multiTenancyCfg.isEnabled()).fold(RestErrorMapper::mapProblemToCompletedResponse, this::evaluateDecision);
    }

    private CompletableFuture<ResponseEntity<Object>> evaluateDecision(RequestMapper.DecisionEvaluationRequest request) {
        return RequestMapper.executeServiceMethod(() -> this.decisionServices.withAuthentication(RequestMapper.getAuthentication()).evaluateDecision(request.decisionId(), request.decisionKey(), request.variables(), request.tenantId()), ResponseMapper::toEvaluateDecisionResponse);
    }
}

