/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.controller;

import io.camunda.service.ClockServices;
import io.camunda.zeebe.gateway.protocol.rest.ClockPinRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.controller.CamundaRestController;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@CamundaRestController
@RequestMapping(value={"/v2/clock"})
public class ClockController {
    private final ClockServices clockServices;

    @Autowired
    public ClockController(ClockServices clockServices) {
        this.clockServices = clockServices;
    }

    @PutMapping(produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> pinClock(@RequestBody ClockPinRequest pinRequest) {
        return (CompletableFuture)RequestMapper.getPinnedEpoch(pinRequest).fold(RestErrorMapper::mapProblemToCompletedResponse, this::pinClock);
    }

    @PostMapping(path={"/reset"}, produces={"application/json", "application/problem+json"})
    public CompletableFuture<ResponseEntity<Object>> resetClock() {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.clockServices.withAuthentication(RequestMapper.getAuthentication()).resetClock());
    }

    private CompletableFuture<ResponseEntity<Object>> pinClock(long pinnedEpoch) {
        return RequestMapper.executeServiceMethodWithNoContentResult(() -> this.clockServices.withAuthentication(RequestMapper.getAuthentication()).pinClock(pinnedEpoch));
    }
}

