/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import java.util.List;
import java.util.Optional;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public final class TenantAttributeHolder {
    private static final String ATTRIBUTE_KEY = "io.camunda.zeebe.gateway.rest.tenantIds";

    private TenantAttributeHolder() {
    }

    public static List<String> tenantIds() {
        RequestAttributes requestAttributes = TenantAttributeHolder.getCurrentRequestAttributes();
        return TenantAttributeHolder.getTenantsOrDefaultTenant(requestAttributes);
    }

    public static void withTenantIds(List<String> tenantIds) {
        RequestAttributes requestAttributes = TenantAttributeHolder.getCurrentRequestAttributes();
        Optional<List<String>> tenantsOptional = Optional.ofNullable(tenantIds);
        requestAttributes.setAttribute(ATTRIBUTE_KEY, tenantsOptional, 0);
    }

    private static RequestAttributes getCurrentRequestAttributes() {
        return RequestContextHolder.currentRequestAttributes();
    }

    private static List<String> getTenantsOrDefaultTenant(RequestAttributes requestAttributes) {
        Object tenants = requestAttributes.getAttribute(ATTRIBUTE_KEY, 0);
        if (tenants != null) {
            return ((Optional)tenants).orElse(null);
        }
        return List.of("<default>");
    }
}

