/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import io.camunda.service.entities.DecisionDefinitionEntity;
import io.camunda.service.entities.DecisionInstanceEntity;
import io.camunda.service.entities.DecisionRequirementsEntity;
import io.camunda.service.entities.FlowNodeInstanceEntity;
import io.camunda.service.entities.IncidentEntity;
import io.camunda.service.entities.OperationEntity;
import io.camunda.service.entities.ProcessInstanceEntity;
import io.camunda.service.entities.ProcessInstanceReference;
import io.camunda.service.entities.UserEntity;
import io.camunda.service.entities.UserTaskEntity;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.zeebe.gateway.protocol.rest.DecisionDefinitionItem;
import io.camunda.zeebe.gateway.protocol.rest.DecisionDefinitionSearchQueryResponse;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceItem;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceSearchQueryResponse;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceStateEnum;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceTypeEnum;
import io.camunda.zeebe.gateway.protocol.rest.DecisionRequirementsItem;
import io.camunda.zeebe.gateway.protocol.rest.DecisionRequirementsSearchQueryResponse;
import io.camunda.zeebe.gateway.protocol.rest.FlowNodeInstanceItem;
import io.camunda.zeebe.gateway.protocol.rest.FlowNodeInstanceSearchQueryResponse;
import io.camunda.zeebe.gateway.protocol.rest.IncidentItem;
import io.camunda.zeebe.gateway.protocol.rest.IncidentSearchQueryResponse;
import io.camunda.zeebe.gateway.protocol.rest.OperationItem;
import io.camunda.zeebe.gateway.protocol.rest.ProblemDetail;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceItem;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceReferenceItem;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceSearchQueryResponse;
import io.camunda.zeebe.gateway.protocol.rest.SearchQueryPageResponse;
import io.camunda.zeebe.gateway.protocol.rest.UserResponse;
import io.camunda.zeebe.gateway.protocol.rest.UserSearchResponse;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskItem;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskSearchQueryResponse;
import io.camunda.zeebe.util.Either;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class SearchQueryResponseMapper {
    private SearchQueryResponseMapper() {
    }

    public static ProcessInstanceSearchQueryResponse toProcessInstanceSearchQueryResponse(SearchQueryResult<ProcessInstanceEntity> result) {
        SearchQueryPageResponse page = SearchQueryResponseMapper.toSearchQueryPageResponse(result);
        return new ProcessInstanceSearchQueryResponse().page(page).items(Optional.ofNullable(result.items()).map(SearchQueryResponseMapper::toProcessInstances).orElseGet(Collections::emptyList));
    }

    public static DecisionDefinitionSearchQueryResponse toDecisionDefinitionSearchQueryResponse(SearchQueryResult<DecisionDefinitionEntity> result) {
        SearchQueryPageResponse page = SearchQueryResponseMapper.toSearchQueryPageResponse(result);
        return new DecisionDefinitionSearchQueryResponse().page(page).items(Optional.ofNullable(result.items()).map(SearchQueryResponseMapper::toDecisionDefinitions).orElseGet(Collections::emptyList));
    }

    public static DecisionRequirementsSearchQueryResponse toDecisionRequirementsSearchQueryResponse(SearchQueryResult<DecisionRequirementsEntity> result) {
        SearchQueryPageResponse page = SearchQueryResponseMapper.toSearchQueryPageResponse(result);
        return new DecisionRequirementsSearchQueryResponse().page(page).items(Optional.ofNullable(result.items()).map(SearchQueryResponseMapper::toDecisionRequirements).orElseGet(Collections::emptyList));
    }

    public static FlowNodeInstanceSearchQueryResponse toFlownodeInstanceSearchQueryResponse(SearchQueryResult<FlowNodeInstanceEntity> result) {
        SearchQueryPageResponse page = SearchQueryResponseMapper.toSearchQueryPageResponse(result);
        return new FlowNodeInstanceSearchQueryResponse().page(page).items(Optional.ofNullable(result.items()).map(SearchQueryResponseMapper::toFlownodeInstance).orElseGet(Collections::emptyList));
    }

    public static DecisionInstanceSearchQueryResponse toDecisionInstanceSearchQueryResponse(SearchQueryResult<DecisionInstanceEntity> result) {
        SearchQueryPageResponse page = SearchQueryResponseMapper.toSearchQueryPageResponse(result);
        return new DecisionInstanceSearchQueryResponse().page(page).items(Optional.ofNullable(result.items()).map(SearchQueryResponseMapper::toDecisionInstances).orElseGet(Collections::emptyList));
    }

    public static UserTaskSearchQueryResponse toUserTaskSearchQueryResponse(SearchQueryResult<UserTaskEntity> result) {
        SearchQueryPageResponse page = SearchQueryResponseMapper.toSearchQueryPageResponse(result);
        return new UserTaskSearchQueryResponse().page(page).items(Optional.ofNullable(result.items()).map(SearchQueryResponseMapper::toUserTasks).orElseGet(Collections::emptyList));
    }

    public static UserSearchResponse toUserSearchQueryResponse(SearchQueryResult<UserEntity> result) {
        UserSearchResponse response = new UserSearchResponse();
        long total = result.total();
        Object[] sortValues = result.sortValues();
        List items = result.items();
        SearchQueryPageResponse page = new SearchQueryPageResponse();
        page.setTotalItems(total);
        response.setPage(page);
        if (sortValues != null) {
            page.setLastSortValues(Arrays.asList(sortValues));
        }
        if (items != null) {
            response.setItems((List)SearchQueryResponseMapper.toUsers(items).get());
        }
        return response;
    }

    public static IncidentSearchQueryResponse toIncidentSearchQueryResponse(SearchQueryResult<IncidentEntity> result) {
        SearchQueryPageResponse page = SearchQueryResponseMapper.toSearchQueryPageResponse(result);
        return new IncidentSearchQueryResponse().page(page).items(Optional.ofNullable(result.items()).map(SearchQueryResponseMapper::toIncidents).orElseGet(Collections::emptyList));
    }

    private static SearchQueryPageResponse toSearchQueryPageResponse(SearchQueryResult<?> result) {
        return new SearchQueryPageResponse().totalItems(result.total()).lastSortValues(Optional.ofNullable(result.sortValues()).map(Arrays::asList).orElseGet(Collections::emptyList));
    }

    private static List<ProcessInstanceItem> toProcessInstances(List<ProcessInstanceEntity> instances) {
        return instances.stream().map(SearchQueryResponseMapper::toProcessInstance).toList();
    }

    private static ProcessInstanceItem toProcessInstance(ProcessInstanceEntity p) {
        return new ProcessInstanceItem().key(p.key()).processDefinitionName(p.processName()).processDefinitionVersion(p.processVersion()).bpmnProcessId(p.bpmnProcessId()).parentKey(p.parentProcessInstanceKey()).parentFlowNodeInstanceKey(p.parentFlowNodeInstanceKey()).startDate(p.startDate()).endDate(p.endDate()).state(p.state() == null ? null : ProcessInstanceItem.StateEnum.fromValue(p.state())).incident(p.incident()).hasActiveOperation(p.hasActiveOperation()).processDefinitionKey(p.processDefinitionKey()).tenantId(p.tenantId()).rootInstanceId(p.rootInstanceId()).operations(SearchQueryResponseMapper.toOperations(p.operations())).callHierarchy(SearchQueryResponseMapper.toCallHierarchy(p.callHierarchy()));
    }

    private static List<OperationItem> toOperations(List<OperationEntity> instances) {
        if (instances == null) {
            return null;
        }
        return instances.stream().map(SearchQueryResponseMapper::toOperation).toList();
    }

    private static OperationItem toOperation(OperationEntity o) {
        return new OperationItem().id(o.id()).batchOperationId(o.batchOperationId()).type(o.type() == null ? null : OperationItem.TypeEnum.fromValue(o.type())).state(o.state() == null ? null : OperationItem.StateEnum.fromValue(o.state())).errorMessage(o.errorMessage()).completedDate(o.completedDate());
    }

    private static List<ProcessInstanceReferenceItem> toCallHierarchy(List<ProcessInstanceReference> instances) {
        if (instances == null) {
            return null;
        }
        return instances.stream().map(SearchQueryResponseMapper::toCallHierarchy).toList();
    }

    private static ProcessInstanceReferenceItem toCallHierarchy(ProcessInstanceReference p) {
        return new ProcessInstanceReferenceItem().instanceId(p.instanceId()).processDefinitionId(p.processDefinitionId()).processDefinitionName(p.processDefinitionName());
    }

    private static List<DecisionDefinitionItem> toDecisionDefinitions(List<DecisionDefinitionEntity> instances) {
        return instances.stream().map(SearchQueryResponseMapper::toDecisionDefinition).toList();
    }

    private static List<DecisionRequirementsItem> toDecisionRequirements(List<DecisionRequirementsEntity> instances) {
        return instances.stream().map(SearchQueryResponseMapper::toDecisionRequirements).toList();
    }

    private static List<FlowNodeInstanceItem> toFlownodeInstance(List<FlowNodeInstanceEntity> instances) {
        return instances.stream().map(SearchQueryResponseMapper::toFlowNodeInstance).toList();
    }

    private static FlowNodeInstanceItem toFlowNodeInstance(FlowNodeInstanceEntity instance) {
        return new FlowNodeInstanceItem().flowNodeInstanceKey(instance.key()).flowNodeId(instance.flowNodeId()).flowNodeName(instance.flowNodeName()).processDefinitionKey(instance.processDefinitionKey()).processInstanceKey(instance.processInstanceKey()).incidentKey(instance.incidentKey()).incident(instance.incident()).startDate(instance.startDate()).endDate(instance.endDate()).state(instance.state()).treePath(instance.treePath()).type(instance.type()).tenantId(instance.tenantId());
    }

    private static DecisionDefinitionItem toDecisionDefinition(DecisionDefinitionEntity d) {
        return new DecisionDefinitionItem().tenantId(d.tenantId()).decisionDefinitionKey(d.key()).decisionDefinitionName(d.name()).version(d.version()).decisionDefinitionId(d.decisionId()).decisionRequirementsKey(d.decisionRequirementsKey()).decisionRequirementsId(d.decisionRequirementsId());
    }

    private static DecisionRequirementsItem toDecisionRequirements(DecisionRequirementsEntity d) {
        return new DecisionRequirementsItem().tenantId(d.tenantId()).decisionRequirementsKey(d.key()).decisionRequirementsName(d.name()).version(d.version()).resourceName(d.resourceName()).decisionRequirementsId(d.decisionRequirementsId());
    }

    private static List<UserTaskItem> toUserTasks(List<UserTaskEntity> tasks) {
        return tasks.stream().map(SearchQueryResponseMapper::toUserTask).toList();
    }

    private static List<IncidentItem> toIncidents(List<IncidentEntity> incidents) {
        return incidents.stream().map(SearchQueryResponseMapper::toIncident).toList();
    }

    public static IncidentItem toIncident(IncidentEntity t) {
        return new IncidentItem().key(t.key()).processDefinitionKey(t.processDefinitionKey()).processDefinitionId(t.bpmnProcessId()).processInstanceKey(t.processInstanceKey()).errorType(IncidentItem.ErrorTypeEnum.fromValue(t.errorType().name())).errorMessage(t.errorMessage()).flowNodeId(t.flowNodeId()).flowNodeInstanceKey(t.flowNodeInstanceKey()).creationTime(t.creationTime()).state(IncidentItem.StateEnum.fromValue(t.state().name())).jobKey(t.jobKey()).treePath(t.treePath()).tenantId(t.tenantId());
    }

    private static UserTaskItem toUserTask(UserTaskEntity t) {
        return new UserTaskItem().tenantIds(t.tenantId()).key(t.key()).processInstanceKey(t.processInstanceId()).processDefinitionKey(t.processDefinitionId()).elementInstanceKey(t.flowNodeInstanceId()).processDefinitionId(t.bpmnProcessId()).state(t.state()).assignee(t.assignee()).candidateUser(t.candidateUsers()).candidateGroup(t.candidateGroups()).formKey(t.formKey()).elementId(t.flowNodeBpmnId()).creationDate(t.creationTime()).completionDate(t.completionTime()).dueDate(t.dueDate()).followUpDate(t.followUpDate()).externalFormReference(t.externalFormReference()).processDefinitionVersion(t.processDefinitionVersion()).customHeaders(t.customHeaders()).priority(t.priority());
    }

    public static Either<ProblemDetail, List<UserResponse>> toUsers(List<UserEntity> users) {
        return Either.right(users.stream().map(SearchQueryResponseMapper::toUser).map(Either::get).toList());
    }

    public static Either<ProblemDetail, UserResponse> toUser(UserEntity user) {
        return Either.right((Object)new UserResponse().key(user.key()).username(user.username()).email(user.email()).name(user.name()));
    }

    private static List<DecisionInstanceItem> toDecisionInstances(List<DecisionInstanceEntity> instances) {
        return instances.stream().map(SearchQueryResponseMapper::toDecisionInstance).toList();
    }

    private static DecisionInstanceItem toDecisionInstance(DecisionInstanceEntity entity) {
        return new DecisionInstanceItem().key(entity.key()).state(entity.state() == null ? null : DecisionInstanceStateEnum.fromValue(entity.state().name())).evaluationDate(entity.evaluationDate()).evaluationFailure(entity.evaluationFailure()).processDefinitionKey(entity.processDefinitionKey()).processInstanceKey(entity.processInstanceKey()).decisionDefinitionKey(Long.valueOf(entity.decisionDefinitionId())).decisionDefinitionId(entity.decisionId()).decisionDefinitionName(entity.decisionName()).decisionDefinitionVersion(entity.decisionVersion()).decisionDefinitionType(entity.decisionType() == null ? null : DecisionInstanceTypeEnum.fromValue(entity.decisionType().name())).result(entity.result());
    }
}

