/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import io.camunda.service.entities.DecisionInstanceEntity;
import io.camunda.service.entities.IncidentEntity;
import io.camunda.service.search.filter.DateValueFilter;
import io.camunda.service.search.filter.DecisionDefinitionFilter;
import io.camunda.service.search.filter.DecisionInstanceFilter;
import io.camunda.service.search.filter.DecisionRequirementsFilter;
import io.camunda.service.search.filter.FilterBase;
import io.camunda.service.search.filter.FilterBuilders;
import io.camunda.service.search.filter.FlowNodeInstanceFilter;
import io.camunda.service.search.filter.IncidentFilter;
import io.camunda.service.search.filter.ProcessInstanceFilter;
import io.camunda.service.search.filter.ProcessInstanceVariableFilter;
import io.camunda.service.search.filter.UserFilter;
import io.camunda.service.search.filter.UserTaskFilter;
import io.camunda.service.search.filter.VariableValueFilter;
import io.camunda.service.search.page.SearchQueryPage;
import io.camunda.service.search.query.DecisionDefinitionQuery;
import io.camunda.service.search.query.DecisionInstanceQuery;
import io.camunda.service.search.query.DecisionRequirementsQuery;
import io.camunda.service.search.query.FlowNodeInstanceQuery;
import io.camunda.service.search.query.IncidentQuery;
import io.camunda.service.search.query.ProcessInstanceQuery;
import io.camunda.service.search.query.SearchQueryBuilders;
import io.camunda.service.search.query.TypedSearchQueryBuilder;
import io.camunda.service.search.query.UserQuery;
import io.camunda.service.search.query.UserTaskQuery;
import io.camunda.service.search.sort.DecisionDefinitionSort;
import io.camunda.service.search.sort.DecisionInstanceSort;
import io.camunda.service.search.sort.DecisionRequirementsSort;
import io.camunda.service.search.sort.FlowNodeInstanceSort;
import io.camunda.service.search.sort.IncidentSort;
import io.camunda.service.search.sort.ProcessInstanceSort;
import io.camunda.service.search.sort.SortOption;
import io.camunda.service.search.sort.SortOptionBuilders;
import io.camunda.service.search.sort.UserSort;
import io.camunda.service.search.sort.UserTaskSort;
import io.camunda.util.ObjectBuilder;
import io.camunda.zeebe.gateway.protocol.rest.DecisionDefinitionFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.DecisionDefinitionSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.DecisionRequirementsFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.DecisionRequirementsSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.FlowNodeInstanceFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.FlowNodeInstanceSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.IncidentFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.IncidentSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceVariableFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.SearchQueryPageRequest;
import io.camunda.zeebe.gateway.protocol.rest.SearchQuerySortRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskSearchQueryRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskVariableFilterRequest;
import io.camunda.zeebe.gateway.protocol.rest.VariableValueFilterRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import io.camunda.zeebe.util.Either;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ProblemDetail;

public final class SearchQueryRequestMapper {
    private SearchQueryRequestMapper() {
    }

    public static Either<ProblemDetail, ProcessInstanceQuery> toProcessInstanceQuery(ProcessInstanceSearchQueryRequest request) {
        if (request == null) {
            return Either.right((Object)SearchQueryBuilders.processInstanceSearchQuery().build());
        }
        Either<List<String>, SearchQueryPage> page = SearchQueryRequestMapper.toSearchQueryPage(request.getPage());
        Either sort = SearchQueryRequestMapper.toSearchQuerySort(request.getSort(), SortOptionBuilders::processInstance, SearchQueryRequestMapper::applyProcessInstanceSortField);
        ProcessInstanceFilter filter = SearchQueryRequestMapper.toProcessInstanceFilter(request.getFilter());
        return SearchQueryRequestMapper.buildSearchQuery(filter, sort, page, SearchQueryBuilders::processInstanceSearchQuery);
    }

    public static Either<ProblemDetail, DecisionDefinitionQuery> toDecisionDefinitionQuery(DecisionDefinitionSearchQueryRequest request) {
        if (request == null) {
            return Either.right((Object)SearchQueryBuilders.decisionDefinitionSearchQuery().build());
        }
        Either<List<String>, SearchQueryPage> page = SearchQueryRequestMapper.toSearchQueryPage(request.getPage());
        Either sort = SearchQueryRequestMapper.toSearchQuerySort(request.getSort(), SortOptionBuilders::decisionDefinition, SearchQueryRequestMapper::applyDecisionDefinitionSortField);
        DecisionDefinitionFilter filter = SearchQueryRequestMapper.toDecisionDefinitionFilter(request.getFilter());
        return SearchQueryRequestMapper.buildSearchQuery(filter, sort, page, SearchQueryBuilders::decisionDefinitionSearchQuery);
    }

    public static Either<ProblemDetail, DecisionRequirementsQuery> toDecisionRequirementsQuery(DecisionRequirementsSearchQueryRequest request) {
        if (request == null) {
            return Either.right((Object)SearchQueryBuilders.decisionRequirementsSearchQuery().build());
        }
        Either<List<String>, SearchQueryPage> page = SearchQueryRequestMapper.toSearchQueryPage(request.getPage());
        Either sort = SearchQueryRequestMapper.toSearchQuerySort(request.getSort(), SortOptionBuilders::decisionRequirements, SearchQueryRequestMapper::applyDecisionRequirementsSortField);
        DecisionRequirementsFilter filter = SearchQueryRequestMapper.toDecisionRequirementsFilter(request.getFilter());
        return SearchQueryRequestMapper.buildSearchQuery(filter, sort, page, SearchQueryBuilders::decisionRequirementsSearchQuery);
    }

    public static Either<ProblemDetail, FlowNodeInstanceQuery> toFlownodeInstanceQuery(FlowNodeInstanceSearchQueryRequest request) {
        if (request == null) {
            return Either.right((Object)SearchQueryBuilders.flownodeInstanceSearchQuery().build());
        }
        Either<List<String>, SearchQueryPage> page = SearchQueryRequestMapper.toSearchQueryPage(request.getPage());
        Either sort = SearchQueryRequestMapper.toSearchQuerySort(request.getSort(), SortOptionBuilders::flownodeInstance, SearchQueryRequestMapper::applyFlownodeInstanceSortField);
        FlowNodeInstanceFilter filter = SearchQueryRequestMapper.toFlownodeInstanceFilter(request.getFilter());
        return SearchQueryRequestMapper.buildSearchQuery(filter, sort, page, SearchQueryBuilders::flownodeInstanceSearchQuery);
    }

    public static Either<ProblemDetail, DecisionInstanceQuery> toDecisionInstanceQuery(DecisionInstanceSearchQueryRequest request) {
        if (request == null) {
            return Either.right((Object)SearchQueryBuilders.decisionInstanceSearchQuery().build());
        }
        Either<List<String>, SearchQueryPage> page = SearchQueryRequestMapper.toSearchQueryPage(request.getPage());
        Either sort = SearchQueryRequestMapper.toSearchQuerySort(request.getSort(), SortOptionBuilders::decisionInstance, SearchQueryRequestMapper::applyDecisionInstanceSortField);
        DecisionInstanceFilter filter = SearchQueryRequestMapper.toDecisionInstanceFilter(request.getFilter());
        return SearchQueryRequestMapper.buildSearchQuery(filter, sort, page, SearchQueryBuilders::decisionInstanceSearchQuery);
    }

    private static DecisionInstanceFilter toDecisionInstanceFilter(DecisionInstanceFilterRequest filter) {
        DecisionInstanceFilter.Builder builder = FilterBuilders.decisionInstance();
        if (filter != null) {
            Optional.ofNullable(filter.getKey()).ifPresent(xva$0 -> builder.keys(new Long[]{xva$0}));
            Optional.ofNullable(filter.getState()).map(s -> SearchQueryRequestMapper.convertEnum(s, DecisionInstanceEntity.DecisionInstanceState.class)).ifPresent(xva$0 -> builder.states(new DecisionInstanceEntity.DecisionInstanceState[]{xva$0}));
            Optional.ofNullable(filter.getEvaluationFailure()).ifPresent(xva$0 -> builder.evaluationFailures(new String[]{xva$0}));
            Optional.ofNullable(filter.getProcessDefinitionKey()).ifPresent(xva$0 -> builder.processDefinitionKeys(new Long[]{xva$0}));
            Optional.ofNullable(filter.getDecisionDefinitionKey()).ifPresent(xva$0 -> builder.decisionKeys(new Long[]{xva$0}));
            Optional.ofNullable(filter.getDecisionDefinitionId()).ifPresent(xva$0 -> builder.dmnDecisionIds(new String[]{xva$0}));
            Optional.ofNullable(filter.getDecisionDefinitionName()).ifPresent(xva$0 -> builder.dmnDecisionNames(new String[]{xva$0}));
            Optional.ofNullable(filter.getDecisionDefinitionVersion()).ifPresent(xva$0 -> builder.decisionVersions(new Integer[]{xva$0}));
            Optional.ofNullable(filter.getDecisionDefinitionType()).map(t -> SearchQueryRequestMapper.convertEnum(t, DecisionInstanceEntity.DecisionInstanceType.class)).ifPresent(xva$0 -> builder.decisionTypes(new DecisionInstanceEntity.DecisionInstanceType[]{xva$0}));
            Optional.ofNullable(filter.getTenantId()).ifPresent(xva$0 -> builder.tenantIds(new String[]{xva$0}));
        }
        return builder.build();
    }

    private static List<String> applyDecisionInstanceSortField(String field, DecisionInstanceSort.Builder builder) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (field == null) {
            validationErrors.add("Sort field must not be null");
        } else {
            switch (field) {
                case "key": {
                    builder.key();
                    break;
                }
                case "state": {
                    builder.state();
                    break;
                }
                case "evaluationDate": {
                    builder.evaluationDate();
                    break;
                }
                case "processDefinitionKey": {
                    builder.processDefinitionKey();
                    break;
                }
                case "decisionKey": {
                    builder.decisionKey();
                    break;
                }
                case "dmnDecisionId": {
                    builder.dmnDecisionId();
                    break;
                }
                case "dmnDecisionName": {
                    builder.dmnDecisionName();
                    break;
                }
                case "decisionVersion": {
                    builder.decisionVersion();
                    break;
                }
                case "decisionType": {
                    builder.decisionType();
                    break;
                }
                case "tenantId": {
                    builder.tenantId();
                    break;
                }
                default: {
                    validationErrors.add("Unknown sortBy: %s".formatted(field));
                }
            }
        }
        return validationErrors;
    }

    private static <Q extends Enum<Q>, E extends Enum<E>> E convertEnum(@NotNull Q sourceEnum, @NotNull Class<E> targetEnumType) {
        return Enum.valueOf(targetEnumType, sourceEnum.name());
    }

    public static Either<ProblemDetail, UserTaskQuery> toUserTaskQuery(UserTaskSearchQueryRequest request) {
        if (request == null) {
            return Either.right((Object)SearchQueryBuilders.userTaskSearchQuery().build());
        }
        Either<List<String>, SearchQueryPage> page = SearchQueryRequestMapper.toSearchQueryPage(request.getPage());
        Either sort = SearchQueryRequestMapper.toSearchQuerySort(request.getSort(), SortOptionBuilders::userTask, SearchQueryRequestMapper::applyUserTaskSortField);
        UserTaskFilter filter = SearchQueryRequestMapper.toUserTaskFilter(request.getFilter());
        return SearchQueryRequestMapper.buildSearchQuery(filter, sort, page, SearchQueryBuilders::userTaskSearchQuery);
    }

    public static Either<ProblemDetail, UserQuery> toUserQuery(UserSearchQueryRequest request) {
        if (request == null) {
            return Either.right((Object)SearchQueryBuilders.userSearchQuery().build());
        }
        Either<List<String>, SearchQueryPage> page = SearchQueryRequestMapper.toSearchQueryPage(request.getPage());
        Either sort = SearchQueryRequestMapper.toSearchQuerySort(request.getSort(), SortOptionBuilders::user, SearchQueryRequestMapper::applyUserSortField);
        UserFilter filter = SearchQueryRequestMapper.toUserFilter(request.getFilter());
        return SearchQueryRequestMapper.buildSearchQuery(filter, sort, page, SearchQueryBuilders::userSearchQuery);
    }

    public static Either<ProblemDetail, IncidentQuery> toIncidentQuery(IncidentSearchQueryRequest request) {
        if (request == null) {
            return Either.right((Object)SearchQueryBuilders.incidentSearchQuery().build());
        }
        Either<List<String>, SearchQueryPage> page = SearchQueryRequestMapper.toSearchQueryPage(request.getPage());
        Either sort = SearchQueryRequestMapper.toSearchQuerySort(request.getSort(), SortOptionBuilders::incident, SearchQueryRequestMapper::applyIncidentSortField);
        IncidentFilter filter = SearchQueryRequestMapper.toIncidentFilter(request.getFilter());
        return SearchQueryRequestMapper.buildSearchQuery(filter, sort, page, SearchQueryBuilders::incidentSearchQuery);
    }

    private static ProcessInstanceFilter toProcessInstanceFilter(ProcessInstanceFilterRequest filter) {
        ProcessInstanceFilter.Builder builder = FilterBuilders.processInstance();
        if (filter != null) {
            Optional.ofNullable(filter.getRunning()).ifPresentOrElse(arg_0 -> ((ProcessInstanceFilter.Builder)builder).running(arg_0), () -> builder.running(false));
            Optional.ofNullable(filter.getActive()).ifPresentOrElse(arg_0 -> ((ProcessInstanceFilter.Builder)builder).active(arg_0), () -> builder.active(false));
            Optional.ofNullable(filter.getIncidents()).ifPresentOrElse(arg_0 -> ((ProcessInstanceFilter.Builder)builder).incidents(arg_0), () -> builder.incidents(false));
            Optional.ofNullable(filter.getFinished()).ifPresentOrElse(arg_0 -> ((ProcessInstanceFilter.Builder)builder).finished(arg_0), () -> builder.finished(false));
            Optional.ofNullable(filter.getCompleted()).ifPresentOrElse(arg_0 -> ((ProcessInstanceFilter.Builder)builder).completed(arg_0), () -> builder.completed(false));
            Optional.ofNullable(filter.getCanceled()).ifPresentOrElse(arg_0 -> ((ProcessInstanceFilter.Builder)builder).canceled(arg_0), () -> builder.canceled(false));
            Optional.ofNullable(filter.getRetriesLeft()).ifPresentOrElse(arg_0 -> ((ProcessInstanceFilter.Builder)builder).retriesLeft(arg_0), () -> builder.retriesLeft(false));
            Optional.ofNullable(filter.getErrorMessage()).ifPresent(arg_0 -> ((ProcessInstanceFilter.Builder)builder).errorMessage(arg_0));
            Optional.ofNullable(filter.getActivityId()).ifPresent(arg_0 -> ((ProcessInstanceFilter.Builder)builder).activityId(arg_0));
            Optional.ofNullable(SearchQueryRequestMapper.toDateValueFilter(filter.getStartDate())).ifPresent(arg_0 -> ((ProcessInstanceFilter.Builder)builder).startDate(arg_0));
            Optional.ofNullable(SearchQueryRequestMapper.toDateValueFilter(filter.getEndDate())).ifPresent(arg_0 -> ((ProcessInstanceFilter.Builder)builder).endDate(arg_0));
            Optional.ofNullable(filter.getBpmnProcessId()).ifPresent(xva$0 -> builder.bpmnProcessIds(new String[]{xva$0}));
            Optional.ofNullable(filter.getProcessDefinitionVersion()).ifPresent(xva$0 -> builder.processDefinitionVersions(new Integer[]{xva$0}));
            Optional.ofNullable(SearchQueryRequestMapper.toProcessInstanceVariableFilter(filter.getVariable())).ifPresent(arg_0 -> ((ProcessInstanceFilter.Builder)builder).variable(arg_0));
            Optional.ofNullable(filter.getBatchOperationId()).ifPresent(xva$0 -> builder.batchOperationIds(new String[]{xva$0}));
            Optional.ofNullable(filter.getParentProcessInstanceKey()).ifPresent(xva$0 -> builder.parentProcessInstanceKeys(new Long[]{xva$0}));
            Optional.ofNullable(filter.getTenantId()).ifPresent(xva$0 -> builder.tenantIds(new String[]{xva$0}));
        }
        return builder.build();
    }

    private static ProcessInstanceVariableFilter toProcessInstanceVariableFilter(ProcessInstanceVariableFilterRequest filter) {
        if (filter != null && filter.getName() != null) {
            ProcessInstanceVariableFilter.Builder builder = FilterBuilders.processInstanceVariable();
            return builder.name(filter.getName()).values(filter.getValues()).build();
        }
        return null;
    }

    private static VariableValueFilter toUserTaskVariableFilter(ProcessInstanceVariableFilterRequest filter) {
        if (filter != null && filter.getName() != null) {
            VariableValueFilter.Builder builder = FilterBuilders.variableValue();
            return (VariableValueFilter)builder.name(filter.getName()).eq(filter.getValues()).build();
        }
        return null;
    }

    private static DecisionDefinitionFilter toDecisionDefinitionFilter(DecisionDefinitionFilterRequest filter) {
        DecisionDefinitionFilter.Builder builder = FilterBuilders.decisionDefinition();
        if (filter != null) {
            Optional.ofNullable(filter.getDecisionDefinitionKey()).ifPresent(xva$0 -> builder.decisionKeys(new Long[]{xva$0}));
            Optional.ofNullable(filter.getDecisionDefinitionId()).ifPresent(xva$0 -> builder.dmnDecisionIds(new String[]{xva$0}));
            Optional.ofNullable(filter.getDecisionDefinitionName()).ifPresent(xva$0 -> builder.dmnDecisionNames(new String[]{xva$0}));
            Optional.ofNullable(filter.getVersion()).ifPresent(xva$0 -> builder.versions(new Integer[]{xva$0}));
            Optional.ofNullable(filter.getDecisionRequirementsId()).ifPresent(xva$0 -> builder.dmnDecisionRequirementsIds(new String[]{xva$0}));
            Optional.ofNullable(filter.getDecisionRequirementsKey()).ifPresent(xva$0 -> builder.decisionRequirementsKeys(new Long[]{xva$0}));
            Optional.ofNullable(filter.getTenantId()).ifPresent(xva$0 -> builder.tenantIds(new String[]{xva$0}));
        }
        return builder.build();
    }

    private static DecisionRequirementsFilter toDecisionRequirementsFilter(DecisionRequirementsFilterRequest filter) {
        DecisionRequirementsFilter.Builder builder = FilterBuilders.decisionRequirements();
        Optional.ofNullable(filter).ifPresent(f -> {
            Optional.ofNullable(f.getDecisionRequirementsKey()).ifPresent(xva$0 -> builder.decisionRequirementsKeys(new Long[]{xva$0}));
            Optional.ofNullable(f.getDecisionRequirementsName()).ifPresent(xva$0 -> builder.dmnDecisionRequirementsNames(new String[]{xva$0}));
            Optional.ofNullable(f.getVersion()).ifPresent(xva$0 -> builder.versions(new Integer[]{xva$0}));
            Optional.ofNullable(f.getDecisionRequirementsId()).ifPresent(xva$0 -> builder.dmnDecisionRequirementsIds(new String[]{xva$0}));
            Optional.ofNullable(f.getTenantId()).ifPresent(xva$0 -> builder.tenantIds(new String[]{xva$0}));
        });
        return builder.build();
    }

    private static FlowNodeInstanceFilter toFlownodeInstanceFilter(FlowNodeInstanceFilterRequest filter) {
        FlowNodeInstanceFilter.Builder builder = FilterBuilders.flownodeInstance();
        Optional.ofNullable(filter).ifPresent(f -> {
            Optional.ofNullable(f.getFlowNodeInstanceKey()).ifPresent(xva$0 -> builder.flowNodeInstanceKeys(new Long[]{xva$0}));
            Optional.ofNullable(f.getProcessInstanceKey()).ifPresent(xva$0 -> builder.processInstanceKeys(new Long[]{xva$0}));
            Optional.ofNullable(f.getProcessDefinitionKey()).ifPresent(xva$0 -> builder.processDefinitionKeys(new Long[]{xva$0}));
            Optional.ofNullable(f.getState()).ifPresent(xva$0 -> builder.states(new String[]{xva$0}));
            Optional.ofNullable(f.getType()).ifPresent(xva$0 -> builder.types(new String[]{xva$0}));
            Optional.ofNullable(f.getFlowNodeId()).ifPresent(xva$0 -> builder.flowNodeIds(new String[]{xva$0}));
            Optional.ofNullable(f.getFlowNodeName()).ifPresent(xva$0 -> builder.flowNodeNames(new String[]{xva$0}));
            Optional.ofNullable(f.getTreePath()).ifPresent(xva$0 -> builder.treePaths(new String[]{xva$0}));
            Optional.ofNullable(f.getIncident()).ifPresent(arg_0 -> ((FlowNodeInstanceFilter.Builder)builder).incident(arg_0));
            Optional.ofNullable(f.getIncidentKey()).ifPresent(xva$0 -> builder.incidentKeys(new Long[]{xva$0}));
            Optional.ofNullable(f.getTenantId()).ifPresent(xva$0 -> builder.tenantIds(new String[]{xva$0}));
        });
        return builder.build();
    }

    private static UserTaskFilter toUserTaskFilter(UserTaskFilterRequest filter) {
        UserTaskFilter.Builder builder = FilterBuilders.userTask();
        Optional.ofNullable(filter).ifPresent(f -> {
            Optional.ofNullable(f.getKey()).ifPresent(xva$0 -> builder.keys(new Long[]{xva$0}));
            Optional.ofNullable(f.getState()).ifPresent(xva$0 -> builder.states(new String[]{xva$0}));
            Optional.ofNullable(f.getProcessDefinitionId()).ifPresent(xva$0 -> builder.bpmnProcessIds(new String[]{xva$0}));
            Optional.ofNullable(f.getElementId()).ifPresent(xva$0 -> builder.elementIds(new String[]{xva$0}));
            Optional.ofNullable(f.getAssignee()).ifPresent(xva$0 -> builder.assignees(new String[]{xva$0}));
            Optional.ofNullable(f.getCandidateGroup()).ifPresent(xva$0 -> builder.candidateGroups(new String[]{xva$0}));
            Optional.ofNullable(f.getCandidateUser()).ifPresent(xva$0 -> builder.candidateUsers(new String[]{xva$0}));
            Optional.ofNullable(f.getProcessDefinitionKey()).ifPresent(xva$0 -> builder.processDefinitionKeys(new Long[]{xva$0}));
            Optional.ofNullable(f.getProcessInstanceKey()).ifPresent(xva$0 -> builder.processInstanceKeys(new Long[]{xva$0}));
            Optional.ofNullable(f.getTenantIds()).ifPresent(xva$0 -> builder.tenantIds(new String[]{xva$0}));
            Optional.ofNullable(f.getVariables()).filter(variables -> !variables.isEmpty()).ifPresent(vars -> builder.variable(SearchQueryRequestMapper.toVariableValueFilters(vars)));
        });
        return builder.build();
    }

    private static UserFilter toUserFilter(UserFilterRequest filter) {
        return Optional.ofNullable(filter).map(f -> FilterBuilders.user().username(f.getUsername()).name(f.getName()).email(f.getEmail()).build()).orElse(null);
    }

    private static IncidentFilter toIncidentFilter(IncidentFilterRequest filter) {
        IncidentFilter.Builder builder = FilterBuilders.incident();
        if (filter != null) {
            Optional.ofNullable(filter.getKey()).ifPresent(x$0 -> builder.keys(x$0, new Long[0]));
            Optional.ofNullable(filter.getProcessDefinitionKey()).ifPresent(x$0 -> builder.processDefinitionKeys(x$0, new Long[0]));
            Optional.ofNullable(filter.getProcessDefinitionId()).ifPresent(x$0 -> builder.bpmnProcessIds(x$0, new String[0]));
            Optional.ofNullable(filter.getProcessInstanceKey()).ifPresent(x$0 -> builder.processInstanceKeys(x$0, new Long[0]));
            Optional.ofNullable(filter.getErrorType()).ifPresent(t -> builder.errorTypes(IncidentEntity.ErrorType.valueOf((String)t.getValue()), new IncidentEntity.ErrorType[0]));
            Optional.ofNullable(filter.getErrorMessage()).ifPresent(x$0 -> builder.errorMessages(x$0, new String[0]));
            Optional.ofNullable(filter.getFlowNodeId()).ifPresent(x$0 -> builder.flowNodeIds(x$0, new String[0]));
            Optional.ofNullable(filter.getFlowNodeInstanceKey()).ifPresent(x$0 -> builder.flowNodeInstanceKeys(x$0, new Long[0]));
            Optional.ofNullable(filter.getCreationTime()).ifPresent(t -> builder.creationTime(SearchQueryRequestMapper.toDateValueFilter(t)));
            Optional.ofNullable(filter.getState()).ifPresent(s -> builder.states(IncidentEntity.IncidentState.valueOf((String)s.getValue()), new IncidentEntity.IncidentState[0]));
            Optional.ofNullable(filter.getJobKey()).ifPresent(x$0 -> builder.jobKeys(x$0, new Long[0]));
            Optional.ofNullable(filter.getTreePath()).ifPresent(x$0 -> builder.treePaths(x$0, new String[0]));
            Optional.ofNullable(filter.getTenantId()).ifPresent(x$0 -> builder.tenantIds(x$0, new String[0]));
        }
        return builder.build();
    }

    private static List<String> applyProcessInstanceSortField(String field, ProcessInstanceSort.Builder builder) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (field == null) {
            validationErrors.add("Sort field must not be null");
        } else {
            switch (field) {
                case "key": {
                    builder.key();
                    break;
                }
                case "processName": {
                    builder.processName();
                    break;
                }
                case "processVersion": {
                    builder.processVersion();
                    break;
                }
                case "bpmnProcessId": {
                    builder.bpmnProcessId();
                    break;
                }
                case "parentKey": {
                    builder.parentKey();
                    break;
                }
                case "parentFlowNodeInstanceKey": {
                    builder.parentFlowNodeInstanceKey();
                    break;
                }
                case "startDate": {
                    builder.startDate();
                    break;
                }
                case "endDate": {
                    builder.endDate();
                    break;
                }
                case "state": {
                    builder.state();
                    break;
                }
                case "incident": {
                    builder.incident();
                    break;
                }
                case "hasActiveOperation": {
                    builder.hasActiveOperation();
                    break;
                }
                case "processDefinitionKey": {
                    builder.processDefinitionKey();
                    break;
                }
                case "tenantId": {
                    builder.tenantId();
                    break;
                }
                case "rootInstanceId": {
                    builder.rootInstanceId();
                    break;
                }
                default: {
                    validationErrors.add("Unknown sortBy: %s".formatted(field));
                }
            }
        }
        return validationErrors;
    }

    private static List<String> applyDecisionDefinitionSortField(String field, DecisionDefinitionSort.Builder builder) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (field == null) {
            validationErrors.add("Sort field must not be null");
        } else {
            switch (field) {
                case "decisionKey": {
                    builder.decisionKey();
                    break;
                }
                case "dmnDecisionId": {
                    builder.dmnDecisionId();
                    break;
                }
                case "dmnDecisionName": {
                    builder.dmnDecisionName();
                    break;
                }
                case "version": {
                    builder.version();
                    break;
                }
                case "dmnDecisionRequirementsId": {
                    builder.dmnDecisionRequirementsId();
                    break;
                }
                case "decisionRequirementsKey": {
                    builder.decisionRequirementsKey();
                    break;
                }
                case "tenantId": {
                    builder.tenantId();
                    break;
                }
                default: {
                    validationErrors.add("Unknown sortBy: %s".formatted(field));
                }
            }
        }
        return validationErrors;
    }

    private static List<String> applyDecisionRequirementsSortField(String field, DecisionRequirementsSort.Builder builder) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (field == null) {
            validationErrors.add("Sort field must not be null");
        } else {
            switch (field) {
                case "decisionRequirementsKey": {
                    builder.decisionRequirementsKey();
                    break;
                }
                case "dmnDecisionRequirementsName": {
                    builder.dmnDecisionRequirementsName();
                    break;
                }
                case "version": {
                    builder.version();
                    break;
                }
                case "dmnDecisionRequirementsId": {
                    builder.dmnDecisionRequirementsId();
                    break;
                }
                case "tenantId": {
                    builder.tenantId();
                    break;
                }
                default: {
                    validationErrors.add("Unknown sortBy: %s".formatted(field));
                }
            }
        }
        return validationErrors;
    }

    private static List<String> applyFlownodeInstanceSortField(String field, FlowNodeInstanceSort.Builder builder) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        return validationErrors;
    }

    private static List<String> applyIncidentSortField(String field, IncidentSort.Builder builder) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (field == null) {
            validationErrors.add("Sort field must not be null");
        } else {
            switch (field) {
                case "key": {
                    builder.key();
                    break;
                }
                case "processDefinitionKey": {
                    builder.processDefinitionKey();
                    break;
                }
                case "bpmnProcessId": {
                    builder.bpmnProcessId();
                    break;
                }
                case "processInstanceKey": {
                    builder.processInstanceKey();
                    break;
                }
                case "errorType": {
                    builder.errorType();
                    break;
                }
                case "errorMessage": {
                    builder.errorMessage();
                    break;
                }
                case "flowNodeId": {
                    builder.flowNodeId();
                    break;
                }
                case "flowNodeInstanceKey": {
                    builder.flowNodeInstanceKey();
                    break;
                }
                case "creationTime": {
                    builder.creationTime();
                    break;
                }
                case "state": {
                    builder.state();
                    break;
                }
                case "jobKey": {
                    builder.jobKey();
                    break;
                }
                case "treePath": {
                    builder.treePath();
                    break;
                }
                case "tenantId": {
                    builder.tenantId();
                    break;
                }
                default: {
                    validationErrors.add("Unknown sortBy: %s".formatted(field));
                }
            }
        }
        return validationErrors;
    }

    private static List<String> applyUserTaskSortField(String field, UserTaskSort.Builder builder) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (field == null) {
            validationErrors.add("Sort field must not be null");
        } else {
            switch (field) {
                case "creationDate": {
                    builder.creationDate();
                    break;
                }
                case "completionDate": {
                    builder.completionDate();
                    break;
                }
                case "priority": {
                    builder.priority();
                    break;
                }
                default: {
                    validationErrors.add("Unknown sortBy: %s".formatted(field));
                }
            }
        }
        return validationErrors;
    }

    private static List<String> applyUserSortField(String field, UserSort.Builder builder) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (field == null) {
            validationErrors.add("Sort field must not be null");
        } else {
            switch (field) {
                case "username": {
                    builder.username();
                    break;
                }
                case "name": {
                    builder.name();
                    break;
                }
                case "email": {
                    builder.email();
                    break;
                }
                default: {
                    validationErrors.add("Unknown sortBy: %s".formatted(field));
                }
            }
        }
        return validationErrors;
    }

    private static List<VariableValueFilter> toVariableValueFilters(List<UserTaskVariableFilterRequest> filters) {
        if (filters != null && !filters.isEmpty()) {
            return filters.stream().map(filter -> (VariableValueFilter)new VariableValueFilter.Builder().name(filter.getName()).eq((Object)filter.getValue()).build()).toList();
        }
        return null;
    }

    private static VariableValueFilter toVariableValueFilter(VariableValueFilterRequest filter) {
        return Optional.ofNullable(filter).map(f -> (VariableValueFilter)FilterBuilders.variableValue().name(f.getName()).eq(f.getEq()).neq(f.getNeq()).gt(f.getGt()).gte(f.getGte()).lt(f.getLt()).lte(f.getLte()).build()).orElse(null);
    }

    private static Either<List<String>, SearchQueryPage> toSearchQueryPage(SearchQueryPageRequest requestedPage) {
        if (requestedPage == null) {
            return Either.right(null);
        }
        Object[] searchAfter = SearchQueryRequestMapper.toArrayOrNull(requestedPage.getSearchAfter());
        Object[] searchBefore = SearchQueryRequestMapper.toArrayOrNull(requestedPage.getSearchBefore());
        if (searchAfter != null && searchBefore != null) {
            return Either.left(List.of("Both searchAfter and searchBefore cannot be set at the same time"));
        }
        return Either.right((Object)SearchQueryPage.of(p -> p.size(requestedPage.getLimit()).from(requestedPage.getFrom()).searchAfter(searchAfter).searchBefore(searchBefore)));
    }

    private static <T, B extends SortOption.AbstractBuilder<B>> Either<List<String>, T> toSearchQuerySort(List<SearchQuerySortRequest> sorting, Supplier<B> builderSupplier, BiFunction<String, B, List<String>> sortFieldMapper) {
        if (sorting != null && !sorting.isEmpty()) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            SortOption.AbstractBuilder builder = (SortOption.AbstractBuilder)builderSupplier.get();
            for (SearchQuerySortRequest sort : sorting) {
                validationErrors.addAll((Collection)sortFieldMapper.apply(sort.getField(), builder));
                validationErrors.addAll(SearchQueryRequestMapper.applySortOrder(sort.getOrder(), builder));
            }
            return validationErrors.isEmpty() ? Either.right((Object)((ObjectBuilder)builder).build()) : Either.left(validationErrors);
        }
        return Either.right(null);
    }

    private static <T, B extends TypedSearchQueryBuilder<T, B, F, S>, F extends FilterBase, S extends SortOption> Either<ProblemDetail, T> buildSearchQuery(F filter, Either<List<String>, S> sorting, Either<List<String>, SearchQueryPage> page, Supplier<B> queryBuilderSupplier) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (sorting.isLeft()) {
            validationErrors.addAll((Collection)sorting.getLeft());
        }
        if (page.isLeft()) {
            validationErrors.addAll((Collection)page.getLeft());
        }
        return RequestMapper.getResult(RequestValidator.createProblemDetail(validationErrors), () -> ((TypedSearchQueryBuilder)((TypedSearchQueryBuilder)((TypedSearchQueryBuilder)((TypedSearchQueryBuilder)queryBuilderSupplier.get()).page((SearchQueryPage)page.get())).filter(filter)).sort((SortOption)sorting.get())).build());
    }

    private static List<String> applySortOrder(String order, SortOption.AbstractBuilder<?> builder) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        switch (order.toLowerCase()) {
            case "asc": {
                builder.asc();
                break;
            }
            case "desc": {
                builder.desc();
                break;
            }
            default: {
                validationErrors.add("Unknown sortOrder: %s".formatted(order));
            }
        }
        return validationErrors;
    }

    private static Object[] toArrayOrNull(List<Object> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.toArray();
    }

    private static DateValueFilter toDateValueFilter(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        OffsetDateTime date = OffsetDateTime.parse(text);
        return new DateValueFilter.Builder().before(date).after(date).build();
    }

    private static DateValueFilter toDateValueFilter(String after, String before) {
        Optional<OffsetDateTime> beforeDateTime = Optional.ofNullable(before).map(OffsetDateTime::parse);
        Optional<OffsetDateTime> afterDateTime = Optional.ofNullable(after).map(OffsetDateTime::parse);
        if (beforeDateTime.isEmpty() && afterDateTime.isEmpty()) {
            return null;
        }
        return new DateValueFilter.Builder().before((OffsetDateTime)beforeDateTime.orElse(null)).after((OffsetDateTime)afterDateTime.orElse(null)).build();
    }
}

