/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import io.camunda.document.api.DocumentMetadataModel;
import io.camunda.service.DocumentServices;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.gateway.impl.job.JobActivationResult;
import io.camunda.zeebe.gateway.protocol.rest.ActivatedJob;
import io.camunda.zeebe.gateway.protocol.rest.CreateProcessInstanceResponse;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentDecision;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentDecisionRequirements;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentForm;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentMetadata;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentProcess;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentResponse;
import io.camunda.zeebe.gateway.protocol.rest.DocumentLink;
import io.camunda.zeebe.gateway.protocol.rest.DocumentMetadata;
import io.camunda.zeebe.gateway.protocol.rest.DocumentReference;
import io.camunda.zeebe.gateway.protocol.rest.EvaluateDecisionResponse;
import io.camunda.zeebe.gateway.protocol.rest.EvaluatedDecisionInputItem;
import io.camunda.zeebe.gateway.protocol.rest.EvaluatedDecisionItem;
import io.camunda.zeebe.gateway.protocol.rest.EvaluatedDecisionOutputItem;
import io.camunda.zeebe.gateway.protocol.rest.JobActivationResponse;
import io.camunda.zeebe.gateway.protocol.rest.MatchedDecisionRuleItem;
import io.camunda.zeebe.gateway.protocol.rest.MessageCorrelationResponse;
import io.camunda.zeebe.gateway.protocol.rest.MessagePublicationResponse;
import io.camunda.zeebe.gateway.protocol.rest.SignalBroadcastResponse;
import io.camunda.zeebe.gateway.protocol.rest.UserCreateResponse;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageCorrelationRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceResultRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.impl.record.value.user.UserRecord;
import io.camunda.zeebe.protocol.record.value.EvaluatedInputValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedOutputValue;
import io.camunda.zeebe.protocol.record.value.MatchedRuleValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public final class ResponseMapper {
    public static JobActivationResult<JobActivationResponse> toActivateJobsResponse(io.camunda.zeebe.gateway.impl.job.JobActivationResponse activationResponse) {
        Iterator jobKeys = activationResponse.brokerResponse().jobKeys().iterator();
        Iterator jobs = activationResponse.brokerResponse().jobs().iterator();
        JobActivationResponse response = new JobActivationResponse();
        while (jobKeys.hasNext() && jobs.hasNext()) {
            LongValue jobKey = (LongValue)jobKeys.next();
            JobRecord job = (JobRecord)jobs.next();
            ActivatedJob activatedJob = ResponseMapper.toActivatedJob(jobKey.getValue(), job);
            response.addJobsItem(activatedJob);
        }
        return new RestJobActivationResult(response);
    }

    private static ActivatedJob toActivatedJob(long jobKey, JobRecord job) {
        return new ActivatedJob().jobKey(jobKey).type(job.getType()).processDefinitionId(job.getBpmnProcessId()).elementId(job.getElementId()).processInstanceKey(job.getProcessInstanceKey()).processDefinitionVersion(job.getProcessDefinitionVersion()).processDefinitionKey(job.getProcessDefinitionKey()).elementInstanceKey(job.getElementInstanceKey()).worker(BufferUtil.bufferAsString((DirectBuffer)job.getWorkerBuffer())).retries(job.getRetries()).deadline(job.getDeadline()).variables(job.getVariables()).customHeaders(job.getCustomHeadersObjectMap()).tenantId(job.getTenantId());
    }

    public static ResponseEntity<Object> toMessageCorrelationResponse(MessageCorrelationRecord brokerResponse) {
        MessageCorrelationResponse response = new MessageCorrelationResponse().messageKey(brokerResponse.getMessageKey()).tenantId(brokerResponse.getTenantId()).processInstanceKey(brokerResponse.getProcessInstanceKey());
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    public static ResponseEntity<Object> toDocumentReference(DocumentServices.DocumentReferenceResponse response) {
        DocumentMetadataModel internalMetadata = response.metadata();
        DocumentMetadata externalMetadata = new DocumentMetadata().expiresAt(Optional.ofNullable(internalMetadata.expiresAt()).map(Object::toString).orElse(null)).fileName(internalMetadata.fileName()).size(internalMetadata.size()).contentType(internalMetadata.contentType());
        Optional.ofNullable(internalMetadata.additionalProperties()).ifPresent(map -> map.forEach(externalMetadata::putAdditionalProperty));
        DocumentReference reference = new DocumentReference().documentType(DocumentReference.DocumentTypeEnum.CAMUNDA).documentId(response.documentId()).storeId(response.storeId()).metadata(externalMetadata);
        return new ResponseEntity((Object)reference, (HttpStatusCode)HttpStatus.CREATED);
    }

    public static ResponseEntity<Object> toDocumentLinkResponse(io.camunda.document.api.DocumentLink documentLink) {
        DocumentLink externalDocumentLink = new DocumentLink();
        externalDocumentLink.setExpiresAt(documentLink.expiresAt().toString());
        externalDocumentLink.setUrl(documentLink.link());
        return new ResponseEntity((Object)externalDocumentLink, (HttpStatusCode)HttpStatus.OK);
    }

    public static ResponseEntity<Object> toDeployResourceResponse(DeploymentRecord brokerResponse) {
        DeploymentResponse response = new DeploymentResponse().deploymentKey(brokerResponse.getDeploymentKey()).tenantId(brokerResponse.getTenantId());
        ResponseMapper.addDeployedProcess(response, brokerResponse.getProcessesMetadata());
        ResponseMapper.addDeployedDecision(response, (ValueArray<DecisionRecord>)brokerResponse.decisionsMetadata());
        ResponseMapper.addDeployedDecisionRequirements(response, (ValueArray<DecisionRequirementsMetadataRecord>)brokerResponse.decisionRequirementsMetadata());
        ResponseMapper.addDeployedForm(response, (ValueArray<FormMetadataRecord>)brokerResponse.formMetadata());
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    public static ResponseEntity<Object> toMessagePublicationResponse(BrokerResponse<MessageRecord> brokerResponse) {
        MessagePublicationResponse response = new MessagePublicationResponse().messageKey(brokerResponse.getKey()).tenantId(((MessageRecord)brokerResponse.getResponse()).getTenantId());
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    private static void addDeployedForm(DeploymentResponse response, ValueArray<FormMetadataRecord> formMetadataRecords) {
        formMetadataRecords.stream().map(form -> new DeploymentForm().formId(form.getFormId()).version(form.getVersion()).formKey(form.getFormKey()).resourceName(form.getResourceName()).tenantId(form.getTenantId())).map(deploymentForm -> new DeploymentMetadata().form((DeploymentForm)deploymentForm)).forEach(response::addDeploymentsItem);
    }

    private static void addDeployedDecisionRequirements(DeploymentResponse response, ValueArray<DecisionRequirementsMetadataRecord> decisionRequirementsMetadataRecords) {
        decisionRequirementsMetadataRecords.stream().map(decisionRequirement -> new DeploymentDecisionRequirements().decisionRequirementsId(decisionRequirement.getDecisionRequirementsId()).version(decisionRequirement.getDecisionRequirementsVersion()).decisionRequirementsName(decisionRequirement.getDecisionRequirementsName()).tenantId(decisionRequirement.getTenantId()).decisionRequirementsKey(decisionRequirement.getDecisionRequirementsKey()).resourceName(decisionRequirement.getResourceName())).map(deploymentDecisionRequirement -> new DeploymentMetadata().decisionRequirements((DeploymentDecisionRequirements)deploymentDecisionRequirement)).forEach(response::addDeploymentsItem);
    }

    private static void addDeployedDecision(DeploymentResponse response, ValueArray<DecisionRecord> decisionRecords) {
        decisionRecords.stream().map(decision -> new DeploymentDecision().decisionDefinitionId(decision.getDecisionId()).version(decision.getVersion()).decisionDefinitionKey(decision.getDecisionKey()).name(decision.getDecisionName()).tenantId(decision.getTenantId()).decisionRequirementsId(decision.getDecisionRequirementsId()).decisionRequirementsKey(decision.getDecisionRequirementsKey())).map(deploymentDecision -> new DeploymentMetadata().decisionDefinition((DeploymentDecision)deploymentDecision)).forEach(response::addDeploymentsItem);
    }

    private static void addDeployedProcess(DeploymentResponse response, List<ProcessMetadataValue> processesMetadata) {
        processesMetadata.stream().map(process -> new DeploymentProcess().processDefinitionId(process.getBpmnProcessId()).processDefinitionVersion(process.getVersion()).processDefinitionKey(process.getProcessDefinitionKey()).tenantId(process.getTenantId()).resourceName(process.getResourceName())).map(deploymentProcess -> new DeploymentMetadata().processDefinition((DeploymentProcess)deploymentProcess)).forEach(response::addDeploymentsItem);
    }

    public static ResponseEntity<Object> toCreateProcessInstanceResponse(ProcessInstanceCreationRecord brokerResponse) {
        return ResponseMapper.buildCreateProcessInstanceResponse(brokerResponse.getProcessDefinitionKey(), brokerResponse.getBpmnProcessId(), brokerResponse.getVersion(), brokerResponse.getProcessInstanceKey(), brokerResponse.getTenantId(), null);
    }

    public static ResponseEntity<Object> toCreateProcessInstanceWithResultResponse(ProcessInstanceResultRecord brokerResponse) {
        return ResponseMapper.buildCreateProcessInstanceResponse(brokerResponse.getProcessDefinitionKey(), brokerResponse.getBpmnProcessId(), brokerResponse.getVersion(), brokerResponse.getProcessInstanceKey(), brokerResponse.getTenantId(), brokerResponse.getVariables());
    }

    private static ResponseEntity<Object> buildCreateProcessInstanceResponse(Long processDefinitionKey, String bpmnProcessId, Integer version, Long processInstanceKey, String tenantId, Map<String, Object> variables) {
        CreateProcessInstanceResponse response = new CreateProcessInstanceResponse().processDefinitionKey(processDefinitionKey).processDefinitionId(bpmnProcessId).processDefinitionVersion(version).processInstanceKey(processInstanceKey).tenantId(tenantId);
        if (variables != null) {
            response.variables(variables);
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    public static ResponseEntity<Object> toSignalBroadcastResponse(BrokerResponse<SignalRecord> brokerResponse) {
        SignalBroadcastResponse response = new SignalBroadcastResponse().signalKey(brokerResponse.getKey()).tenantId(((SignalRecord)brokerResponse.getResponse()).getTenantId());
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    public static ResponseEntity<Object> toUserCreateResponse(UserRecord userRecord) {
        UserCreateResponse response = new UserCreateResponse().userKey(userRecord.getUserKey());
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.ACCEPTED);
    }

    public static ResponseEntity<Object> toEvaluateDecisionResponse(BrokerResponse<DecisionEvaluationRecord> brokerResponse) {
        DecisionEvaluationRecord decisionEvaluationRecord = (DecisionEvaluationRecord)brokerResponse.getResponse();
        EvaluateDecisionResponse response = new EvaluateDecisionResponse().decisionDefinitionId(decisionEvaluationRecord.getDecisionId()).decisionDefinitionKey(decisionEvaluationRecord.getDecisionKey()).decisionDefinitionName(decisionEvaluationRecord.getDecisionName()).decisionDefinitionVersion(decisionEvaluationRecord.getDecisionVersion()).decisionRequirementsId(decisionEvaluationRecord.getDecisionRequirementsId()).decisionRequirementsKey(decisionEvaluationRecord.getDecisionRequirementsKey()).output(decisionEvaluationRecord.getDecisionOutput()).failedDecisionDefinitionId(decisionEvaluationRecord.getFailedDecisionId()).failureMessage(decisionEvaluationRecord.getEvaluationFailureMessage()).tenantId(decisionEvaluationRecord.getTenantId()).decisionInstanceKey(brokerResponse.getKey());
        ResponseMapper.buildEvaluatedDecisions(decisionEvaluationRecord, response);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    private static void buildEvaluatedDecisions(DecisionEvaluationRecord decisionEvaluationRecord, EvaluateDecisionResponse response) {
        decisionEvaluationRecord.getEvaluatedDecisions().stream().map(evaluatedDecision -> new EvaluatedDecisionItem().decisionDefinitionKey(evaluatedDecision.getDecisionKey()).decisionDefinitionId(evaluatedDecision.getDecisionId()).decisionDefinitionName(evaluatedDecision.getDecisionName()).decisionDefinitionVersion(evaluatedDecision.getDecisionVersion()).output(evaluatedDecision.getDecisionOutput()).tenantId(evaluatedDecision.getTenantId()).evaluatedInputs(ResponseMapper.buildEvaluatedInputs(evaluatedDecision.getEvaluatedInputs())).matchedRules(ResponseMapper.buildMatchedRules(evaluatedDecision.getMatchedRules()))).forEach(response::addEvaluatedDecisionsItem);
    }

    private static List<MatchedDecisionRuleItem> buildMatchedRules(List<MatchedRuleValue> matchedRuleValues) {
        return matchedRuleValues.stream().map(matchedRuleValue -> new MatchedDecisionRuleItem().ruleId(matchedRuleValue.getRuleId()).ruleIndex(matchedRuleValue.getRuleIndex()).evaluatedOutputs(ResponseMapper.buildEvaluatedOutputs(matchedRuleValue.getEvaluatedOutputs()))).toList();
    }

    private static List<EvaluatedDecisionOutputItem> buildEvaluatedOutputs(List<EvaluatedOutputValue> evaluatedOutputs) {
        return evaluatedOutputs.stream().map(evaluatedOutput -> new EvaluatedDecisionOutputItem().outputId(evaluatedOutput.getOutputId()).outputName(evaluatedOutput.getOutputName()).outputValue(evaluatedOutput.getOutputValue())).toList();
    }

    private static List<EvaluatedDecisionInputItem> buildEvaluatedInputs(List<EvaluatedInputValue> inputValues) {
        return inputValues.stream().map(evaluatedInputValue -> new EvaluatedDecisionInputItem().inputId(evaluatedInputValue.getInputId()).inputName(evaluatedInputValue.getInputName()).inputValue(evaluatedInputValue.getInputValue())).toList();
    }

    static class RestJobActivationResult
    implements JobActivationResult<JobActivationResponse> {
        private final JobActivationResponse response;

        RestJobActivationResult(JobActivationResponse response) {
            this.response = response;
        }

        public int getJobsCount() {
            return this.response.getJobs().size();
        }

        public List<JobActivationResult.ActivatedJob> getJobs() {
            return this.response.getJobs().stream().map(j -> new JobActivationResult.ActivatedJob(j.getJobKey().longValue(), j.getRetries().intValue())).toList();
        }

        public JobActivationResponse getActivateJobsResponse() {
            return this.response;
        }

        public List<JobActivationResult.ActivatedJob> getJobsToDefer() {
            return Collections.emptyList();
        }
    }
}

