/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import io.camunda.document.api.DocumentMetadataModel;
import io.camunda.service.AuthorizationServices;
import io.camunda.service.DocumentServices;
import io.camunda.service.ElementInstanceServices;
import io.camunda.service.JobServices;
import io.camunda.service.MessageServices;
import io.camunda.service.ProcessInstanceServices;
import io.camunda.service.ResourceServices;
import io.camunda.service.UserServices;
import io.camunda.service.security.auth.Authentication;
import io.camunda.zeebe.auth.impl.Authorization;
import io.camunda.zeebe.gateway.protocol.rest.AuthorizationPatchRequest;
import io.camunda.zeebe.gateway.protocol.rest.CancelProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.Changeset;
import io.camunda.zeebe.gateway.protocol.rest.ClockPinRequest;
import io.camunda.zeebe.gateway.protocol.rest.CreateProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.DeleteResourceRequest;
import io.camunda.zeebe.gateway.protocol.rest.DocumentLinkRequest;
import io.camunda.zeebe.gateway.protocol.rest.DocumentMetadata;
import io.camunda.zeebe.gateway.protocol.rest.EvaluateDecisionRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobActivationRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobCompletionRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobErrorRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobFailRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobUpdateRequest;
import io.camunda.zeebe.gateway.protocol.rest.MessageCorrelationRequest;
import io.camunda.zeebe.gateway.protocol.rest.MessagePublicationRequest;
import io.camunda.zeebe.gateway.protocol.rest.MigrateProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceActivateInstruction;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.SetVariableRequest;
import io.camunda.zeebe.gateway.protocol.rest.SignalBroadcastRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskAssignmentRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskCompletionRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskUpdateRequest;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.TenantAttributeHolder;
import io.camunda.zeebe.gateway.rest.validator.AuthorizationRequestValidator;
import io.camunda.zeebe.gateway.rest.validator.ClockValidator;
import io.camunda.zeebe.gateway.rest.validator.DocumentValidator;
import io.camunda.zeebe.gateway.rest.validator.ElementRequestValidator;
import io.camunda.zeebe.gateway.rest.validator.EvaluateDecisionRequestValidator;
import io.camunda.zeebe.gateway.rest.validator.JobRequestValidator;
import io.camunda.zeebe.gateway.rest.validator.MessageRequestValidator;
import io.camunda.zeebe.gateway.rest.validator.MultiTenancyValidator;
import io.camunda.zeebe.gateway.rest.validator.ProcessInstanceRequestValidator;
import io.camunda.zeebe.gateway.rest.validator.ResourceRequestValidator;
import io.camunda.zeebe.gateway.rest.validator.SignalRequestValidator;
import io.camunda.zeebe.gateway.rest.validator.UserTaskRequestValidator;
import io.camunda.zeebe.gateway.rest.validator.UserValidator;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationMappingInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationActivateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationVariableInstruction;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceType;
import io.camunda.zeebe.protocol.record.value.PermissionAction;
import io.camunda.zeebe.protocol.record.value.PermissionType;
import io.camunda.zeebe.util.Either;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.multipart.MultipartFile;

public class RequestMapper {
    public static CompleteUserTaskRequest toUserTaskCompletionRequest(UserTaskCompletionRequest completionRequest, long userTaskKey) {
        return new CompleteUserTaskRequest(userTaskKey, RequestMapper.getMapOrEmpty(completionRequest, UserTaskCompletionRequest::getVariables), RequestMapper.getStringOrEmpty(completionRequest, UserTaskCompletionRequest::getAction));
    }

    public static Either<ProblemDetail, AssignUserTaskRequest> toUserTaskAssignmentRequest(UserTaskAssignmentRequest assignmentRequest, long userTaskKey) {
        String actionValue = RequestMapper.getStringOrEmpty(assignmentRequest, UserTaskAssignmentRequest::getAction);
        boolean allowOverride = assignmentRequest.getAllowOverride() == null || assignmentRequest.getAllowOverride() != false;
        return RequestMapper.getResult(UserTaskRequestValidator.validateAssignmentRequest(assignmentRequest), () -> new AssignUserTaskRequest(userTaskKey, assignmentRequest.getAssignee(), actionValue.isBlank() ? "assign" : actionValue, allowOverride));
    }

    public static AssignUserTaskRequest toUserTaskUnassignmentRequest(long userTaskKey) {
        return new AssignUserTaskRequest(userTaskKey, "", "unassign", true);
    }

    public static Either<ProblemDetail, UpdateUserTaskRequest> toUserTaskUpdateRequest(UserTaskUpdateRequest updateRequest, long userTaskKey) {
        return RequestMapper.getResult(UserTaskRequestValidator.validateUpdateRequest(updateRequest), () -> new UpdateUserTaskRequest(userTaskKey, RequestMapper.getRecordWithChangedAttributes(updateRequest), RequestMapper.getStringOrEmpty(updateRequest, UserTaskUpdateRequest::getAction)));
    }

    public static Either<ProblemDetail, Long> getPinnedEpoch(ClockPinRequest pinRequest) {
        return RequestMapper.getResult(ClockValidator.validateClockPinRequest(pinRequest), pinRequest::getTimestamp);
    }

    public static Either<ProblemDetail, JobServices.ActivateJobsRequest> toJobsActivationRequest(JobActivationRequest activationRequest) {
        return RequestMapper.getResult(JobRequestValidator.validateJobActivationRequest(activationRequest), () -> new JobServices.ActivateJobsRequest(activationRequest.getType(), activationRequest.getMaxJobsToActivate().intValue(), RequestMapper.getStringListOrEmpty(activationRequest, JobActivationRequest::getTenantIds), activationRequest.getTimeout().longValue(), RequestMapper.getStringOrEmpty(activationRequest, JobActivationRequest::getWorker), RequestMapper.getStringListOrEmpty(activationRequest, JobActivationRequest::getFetchVariable), RequestMapper.getLongOrZero(activationRequest, JobActivationRequest::getRequestTimeout)));
    }

    public static FailJobRequest toJobFailRequest(JobFailRequest failRequest, long jobKey) {
        return new FailJobRequest(jobKey, RequestMapper.getIntOrZero(failRequest, JobFailRequest::getRetries), RequestMapper.getStringOrEmpty(failRequest, JobFailRequest::getErrorMessage), RequestMapper.getLongOrZero(failRequest, JobFailRequest::getRetryBackOff), RequestMapper.getMapOrEmpty(failRequest, JobFailRequest::getVariables));
    }

    public static Either<ProblemDetail, ErrorJobRequest> toJobErrorRequest(JobErrorRequest errorRequest, long jobKey) {
        Optional<ProblemDetail> validationErrorResponse = JobRequestValidator.validateJobErrorRequest(errorRequest);
        return RequestMapper.getResult(validationErrorResponse, () -> new ErrorJobRequest(jobKey, errorRequest.getErrorCode(), RequestMapper.getStringOrEmpty(errorRequest, JobErrorRequest::getErrorMessage), RequestMapper.getMapOrEmpty(errorRequest, JobErrorRequest::getVariables)));
    }

    public static Either<ProblemDetail, MessageServices.CorrelateMessageRequest> toMessageCorrelationRequest(MessageCorrelationRequest correlationRequest, boolean multiTenancyEnabled) {
        Either validationResponse = MultiTenancyValidator.validateTenantId(correlationRequest.getTenantId(), multiTenancyEnabled, "Correlate Message").flatMap(tenantId -> MultiTenancyValidator.validateAuthorization(tenantId, multiTenancyEnabled, "Correlate Message").map(Either::left).orElseGet(() -> Either.right((Object)tenantId))).flatMap(tenantId -> MessageRequestValidator.validateMessageCorrelationRequest(correlationRequest).map(Either::left).orElseGet(() -> Either.right((Object)tenantId)));
        return validationResponse.map(tenantId -> new MessageServices.CorrelateMessageRequest(correlationRequest.getName(), correlationRequest.getCorrelationKey(), correlationRequest.getVariables(), tenantId));
    }

    public static CompleteJobRequest toJobCompletionRequest(JobCompletionRequest completionRequest, long jobKey) {
        return new CompleteJobRequest(jobKey, RequestMapper.getMapOrEmpty(completionRequest, JobCompletionRequest::getVariables));
    }

    public static Either<ProblemDetail, UpdateJobRequest> toJobUpdateRequest(JobUpdateRequest updateRequest, long jobKey) {
        Optional<ProblemDetail> validationJobUpdateResponse = JobRequestValidator.validateJobUpdateRequest(updateRequest);
        return RequestMapper.getResult(validationJobUpdateResponse, () -> new UpdateJobRequest(jobKey, new JobServices.UpdateJobChangeset(updateRequest.getChangeset().getRetries(), updateRequest.getChangeset().getTimeout())));
    }

    public static Either<ProblemDetail, AuthorizationServices.PatchAuthorizationRequest> toAuthorizationPatchRequest(long ownerKey, AuthorizationPatchRequest authorizationPatchRequest) {
        return RequestMapper.getResult(AuthorizationRequestValidator.validateAuthorizationAssignRequest(authorizationPatchRequest), () -> {
            HashMap permissions = new HashMap();
            authorizationPatchRequest.getPermissions().forEach(permission -> permissions.put(PermissionType.valueOf((String)permission.getPermissionType().name()), permission.getResourceIds()));
            return new AuthorizationServices.PatchAuthorizationRequest(ownerKey, PermissionAction.valueOf((String)authorizationPatchRequest.getAction().name()), AuthorizationResourceType.valueOf((String)authorizationPatchRequest.getResourceType().name()), permissions);
        });
    }

    public static Either<ProblemDetail, DocumentServices.DocumentCreateRequest> toDocumentCreateRequest(String documentId, String storeId, MultipartFile file, DocumentMetadata metadata) {
        InputStream inputStream;
        try {
            inputStream = file.getInputStream();
        }
        catch (IOException e) {
            return Either.left((Object)RequestMapper.createInternalErrorProblemDetail(e, "Failed to read document content"));
        }
        Optional<ProblemDetail> validationResponse = DocumentValidator.validateDocumentMetadata(metadata);
        DocumentMetadataModel internalMetadata = RequestMapper.toInternalDocumentMetadata(metadata, file);
        return RequestMapper.getResult(validationResponse, () -> new DocumentServices.DocumentCreateRequest(documentId, storeId, inputStream, internalMetadata));
    }

    public static Either<ProblemDetail, DocumentServices.DocumentLinkParams> toDocumentLinkParams(DocumentLinkRequest documentLinkRequest) {
        return RequestMapper.getResult(DocumentValidator.validateDocumentLinkParams(documentLinkRequest), () -> new DocumentServices.DocumentLinkParams(ZonedDateTime.parse(documentLinkRequest.getExpiresAt())));
    }

    public static Either<ProblemDetail, UserServices.CreateUserRequest> toCreateUserRequest(UserRequest request, PasswordEncoder passwordEncoder) {
        return RequestMapper.getResult(UserValidator.validateUserCreateRequest(request), () -> new UserServices.CreateUserRequest(request.getUsername(), request.getName(), request.getEmail(), passwordEncoder.encode((CharSequence)request.getPassword())));
    }

    public static <BrokerResponseT> CompletableFuture<ResponseEntity<Object>> executeServiceMethod(Supplier<CompletableFuture<BrokerResponseT>> method, Function<BrokerResponseT, ResponseEntity<Object>> result) {
        return method.get().handleAsync((response, error) -> RestErrorMapper.getResponse(error, RestErrorMapper.DEFAULT_REJECTION_MAPPER).orElseGet(() -> (ResponseEntity)result.apply(response)));
    }

    public static <BrokerResponseT> CompletableFuture<ResponseEntity<Object>> executeServiceMethodWithNoContentResult(Supplier<CompletableFuture<BrokerResponseT>> method) {
        return RequestMapper.executeServiceMethod(method, ignored -> ResponseEntity.noContent().build());
    }

    public static Either<ProblemDetail, ResourceServices.DeployResourcesRequest> toDeployResourceRequest(List<MultipartFile> resources, String tenantId, boolean multiTenancyEnabled) {
        try {
            Either validationResponse = MultiTenancyValidator.validateTenantId(tenantId, multiTenancyEnabled, "Deploy Resources").flatMap(tenant -> MultiTenancyValidator.validateAuthorization(tenant, multiTenancyEnabled, "Deploy Resources").map(Either::left).orElseGet(() -> Either.right((Object)tenant)));
            if (validationResponse.isLeft()) {
                return Either.left((Object)((ProblemDetail)validationResponse.getLeft()));
            }
            return Either.right((Object)RequestMapper.createDeployResourceRequest(resources, (String)validationResponse.get()));
        }
        catch (IOException e) {
            return Either.left((Object)RequestMapper.createInternalErrorProblemDetail(e, "Failed to read resources content"));
        }
    }

    public static Either<ProblemDetail, ElementInstanceServices.SetVariablesRequest> toVariableRequest(SetVariableRequest variableRequest, long elementInstanceKey) {
        return RequestMapper.getResult(ElementRequestValidator.validateVariableRequest(variableRequest), () -> new ElementInstanceServices.SetVariablesRequest(elementInstanceKey, variableRequest.getVariables(), variableRequest.getLocal(), variableRequest.getOperationReference()));
    }

    public static Either<ProblemDetail, MessageServices.PublicationMessageRequest> toMessagePublicationRequest(MessagePublicationRequest messagePublicationRequest, boolean multiTenancyEnabled) {
        Either validationResponse = MultiTenancyValidator.validateTenantId(messagePublicationRequest.getTenantId(), multiTenancyEnabled, "Publish Message").flatMap(tenantId -> MultiTenancyValidator.validateAuthorization(tenantId, multiTenancyEnabled, "Publish Message").map(Either::left).orElseGet(() -> Either.right((Object)tenantId))).flatMap(tenantId -> MessageRequestValidator.validateMessagePublicationRequest(messagePublicationRequest).map(Either::left).orElseGet(() -> Either.right((Object)tenantId)));
        return validationResponse.map(tenantId -> new MessageServices.PublicationMessageRequest(messagePublicationRequest.getName(), messagePublicationRequest.getCorrelationKey(), messagePublicationRequest.getTimeToLive(), RequestMapper.getStringOrEmpty(messagePublicationRequest, MessagePublicationRequest::getMessageId), RequestMapper.getMapOrEmpty(messagePublicationRequest, MessagePublicationRequest::getVariables), tenantId));
    }

    public static Either<ProblemDetail, ResourceServices.ResourceDeletionRequest> toResourceDeletion(long resourceKey, DeleteResourceRequest deleteRequest) {
        Long operationReference = deleteRequest != null ? deleteRequest.getOperationReference() : null;
        return RequestMapper.getResult(ResourceRequestValidator.validateResourceDeletion(deleteRequest), () -> new ResourceServices.ResourceDeletionRequest(resourceKey, operationReference));
    }

    public static Either<ProblemDetail, BroadcastSignalRequest> toBroadcastSignalRequest(SignalBroadcastRequest request, boolean multiTenancyEnabled) {
        Either validationResponse = MultiTenancyValidator.validateTenantId(request.getTenantId(), multiTenancyEnabled, "Broadcast Signal").flatMap(tenantId -> MultiTenancyValidator.validateAuthorization(tenantId, multiTenancyEnabled, "Broadcast Signal").map(Either::left).orElseGet(() -> Either.right((Object)tenantId))).flatMap(tenantId -> SignalRequestValidator.validateSignalBroadcastRequest(request).map(Either::left).orElseGet(() -> Either.right((Object)tenantId)));
        return validationResponse.map(tenantId -> new BroadcastSignalRequest(request.getSignalName(), request.getVariables(), (String)tenantId));
    }

    public static Authentication getAuthentication() {
        List<String> authorizedTenants = TenantAttributeHolder.tenantIds();
        String token = Authorization.jwtEncoder().withIssuer("zeebe-gateway").withAudience("zeebe-broker").withSubject("zeebe-client").withClaim("authorized_tenants", authorizedTenants).encode();
        return new Authentication.Builder().token(token).tenants(authorizedTenants).build();
    }

    public static <T> Either<ProblemDetail, T> getResult(Optional<ProblemDetail> error, Supplier<T> resultSupplier) {
        return error.map(Either::left).orElseGet(() -> Either.right(resultSupplier.get()));
    }

    private static UserTaskRecord getRecordWithChangedAttributes(UserTaskUpdateRequest updateRequest) {
        UserTaskRecord record = new UserTaskRecord();
        if (updateRequest == null || updateRequest.getChangeset() == null) {
            return record;
        }
        Changeset changeset = updateRequest.getChangeset();
        if (changeset.getCandidateGroups() != null) {
            record.setCandidateGroupsList(changeset.getCandidateGroups()).setCandidateGroupsChanged();
        }
        if (changeset.getCandidateUsers() != null) {
            record.setCandidateUsersList(changeset.getCandidateUsers()).setCandidateUsersChanged();
        }
        if (changeset.getDueDate() != null) {
            record.setDueDate(changeset.getDueDate()).setDueDateChanged();
        }
        if (changeset.getFollowUpDate() != null) {
            record.setFollowUpDate(changeset.getFollowUpDate()).setFollowUpDateChanged();
        }
        if (changeset.getPriority() != null) {
            record.setPriority(changeset.getPriority().intValue()).setPriorityChanged();
        }
        return record;
    }

    private static DocumentMetadataModel toInternalDocumentMetadata(DocumentMetadata metadata, MultipartFile file) {
        if (metadata == null) {
            return new DocumentMetadataModel(file.getContentType(), file.getOriginalFilename(), null, Long.valueOf(file.getSize()), Map.of());
        }
        ZonedDateTime expiresAt = metadata.getExpiresAt() == null || metadata.getExpiresAt().isBlank() ? null : ZonedDateTime.parse(metadata.getExpiresAt());
        String fileName = Optional.ofNullable(metadata.getFileName()).orElse(file.getOriginalFilename());
        String contentType = Optional.ofNullable(metadata.getContentType()).orElse(file.getContentType());
        return new DocumentMetadataModel(contentType, fileName, expiresAt, Long.valueOf(file.getSize()), metadata.getAdditionalProperties());
    }

    private static ResourceServices.DeployResourcesRequest createDeployResourceRequest(List<MultipartFile> resources, String tenantId) throws IOException {
        HashMap<String, byte[]> resourceMap = new HashMap<String, byte[]>();
        for (MultipartFile resource : resources) {
            resourceMap.put(resource.getOriginalFilename(), resource.getBytes());
        }
        return new ResourceServices.DeployResourcesRequest(resourceMap, tenantId);
    }

    private static ProblemDetail createInternalErrorProblemDetail(IOException e, String message) {
        return RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), message);
    }

    public static Either<ProblemDetail, ProcessInstanceServices.ProcessInstanceCreateRequest> toCreateProcessInstance(CreateProcessInstanceRequest request, boolean multiTenancyEnabled) {
        Either validationResponse = MultiTenancyValidator.validateTenantId(request.getTenantId(), multiTenancyEnabled, "Create Process Instance").flatMap(tenant -> MultiTenancyValidator.validateAuthorization(tenant, multiTenancyEnabled, "Create Process Instance").map(Either::left).orElseGet(() -> Either.right((Object)tenant))).flatMap(tenant -> ProcessInstanceRequestValidator.validateCreateProcessInstanceRequest(request).map(Either::left).orElseGet(() -> Either.right((Object)tenant)));
        return validationResponse.map(tenantId -> new ProcessInstanceServices.ProcessInstanceCreateRequest(Long.valueOf(RequestMapper.getLongOrDefault(request, CreateProcessInstanceRequest::getProcessDefinitionKey, -1L)), RequestMapper.getStringOrEmpty(request, CreateProcessInstanceRequest::getProcessDefinitionId), Integer.valueOf(RequestMapper.getIntOrDefault(request, CreateProcessInstanceRequest::getProcessDefinitionVersion, -1)), RequestMapper.getMapOrEmpty(request, CreateProcessInstanceRequest::getVariables), tenantId, request.getAwaitCompletion(), request.getRequestTimeout(), request.getOperationReference(), request.getStartInstructions().stream().map(instruction -> new ProcessInstanceCreationStartInstruction().setElementId(instruction.getElementId())).toList(), request.getFetchVariables()));
    }

    public static Either<ProblemDetail, ProcessInstanceServices.ProcessInstanceCancelRequest> toCancelProcessInstance(long processInstanceKey, CancelProcessInstanceRequest request) {
        Long operationReference = request != null ? request.getOperationReference() : null;
        return RequestMapper.getResult(ProcessInstanceRequestValidator.validateCancelProcessInstanceRequest(request), () -> new ProcessInstanceServices.ProcessInstanceCancelRequest(Long.valueOf(processInstanceKey), operationReference));
    }

    public static Either<ProblemDetail, ProcessInstanceServices.ProcessInstanceMigrateRequest> toMigrateProcessInstance(long processInstanceKey, MigrateProcessInstanceRequest request) {
        return RequestMapper.getResult(ProcessInstanceRequestValidator.validateMigrateProcessInstanceRequest(request), () -> new ProcessInstanceServices.ProcessInstanceMigrateRequest(Long.valueOf(processInstanceKey), request.getTargetProcessDefinitionKey(), request.getMappingInstructions().stream().map(instruction -> new ProcessInstanceMigrationMappingInstruction().setSourceElementId(instruction.getSourceElementId()).setTargetElementId(instruction.getTargetElementId())).toList(), request.getOperationReference()));
    }

    public static Either<ProblemDetail, ProcessInstanceServices.ProcessInstanceModifyRequest> toModifyProcessInstance(long processInstanceKey, ModifyProcessInstanceRequest request) {
        return RequestMapper.getResult(ProcessInstanceRequestValidator.validateModifyProcessInstanceRequest(request), () -> new ProcessInstanceServices.ProcessInstanceModifyRequest(Long.valueOf(processInstanceKey), RequestMapper.mapProcessInstanceModificationActivateInstruction(request.getActivateInstructions()), request.getTerminateInstructions().stream().map(terminateInstruction -> new ProcessInstanceModificationTerminateInstruction().setElementInstanceKey(terminateInstruction.getElementInstanceKey().longValue())).toList(), request.getOperationReference()));
    }

    public static Either<ProblemDetail, DecisionEvaluationRequest> toEvaluateDecisionRequest(EvaluateDecisionRequest request, boolean multiTenancyEnabled) {
        Either validationResponse = MultiTenancyValidator.validateTenantId(request.getTenantId(), multiTenancyEnabled, "Evaluate Decision").flatMap(tenantId -> MultiTenancyValidator.validateAuthorization(tenantId, multiTenancyEnabled, "Evaluate Decision").map(Either::left).orElseGet(() -> Either.right((Object)tenantId))).flatMap(tenantId -> EvaluateDecisionRequestValidator.validateEvaluateDecisionRequest(request).map(Either::left).orElseGet(() -> Either.right((Object)tenantId)));
        return validationResponse.map(tenantId -> new DecisionEvaluationRequest(RequestMapper.getStringOrEmpty(request, EvaluateDecisionRequest::getDecisionDefinitionId), RequestMapper.getLongOrDefault(request, EvaluateDecisionRequest::getDecisionDefinitionKey, -1L), RequestMapper.getMapOrEmpty(request, EvaluateDecisionRequest::getVariables), (String)tenantId));
    }

    private static List<ProcessInstanceModificationActivateInstruction> mapProcessInstanceModificationActivateInstruction(List<ModifyProcessInstanceActivateInstruction> instructions) {
        return instructions.stream().map(instruction -> {
            ProcessInstanceModificationActivateInstruction mappedInstruction = new ProcessInstanceModificationActivateInstruction();
            mappedInstruction.setElementId(instruction.getElementId()).setAncestorScopeKey(instruction.getAncestorElementInstanceKey().longValue());
            instruction.getVariableInstructions().stream().map(variable -> new ProcessInstanceModificationVariableInstruction().setElementId(variable.getScopeId()).setVariables((DirectBuffer)new UnsafeBuffer(MsgPackConverter.convertToMsgPack(variable.getVariables())))).forEach(arg_0 -> ((ProcessInstanceModificationActivateInstruction)mappedInstruction).addVariableInstruction(arg_0));
            return mappedInstruction;
        }).toList();
    }

    private static <R> Map<String, Object> getMapOrEmpty(R request, Function<R, Map<String, Object>> mapExtractor) {
        return request == null ? Map.of() : mapExtractor.apply(request);
    }

    private static <R> String getStringOrEmpty(R request, Function<R, String> valueExtractor) {
        String value = request == null ? null : valueExtractor.apply(request);
        return value == null ? "" : value;
    }

    private static <R> long getLongOrZero(R request, Function<R, Long> valueExtractor) {
        return RequestMapper.getLongOrDefault(request, valueExtractor, 0L);
    }

    private static <R> long getLongOrDefault(R request, Function<R, Long> valueExtractor, Long defaultValue) {
        Long value = request == null ? null : valueExtractor.apply(request);
        return value == null ? defaultValue : value;
    }

    private static <R> List<String> getStringListOrEmpty(R request, Function<R, List<String>> valueExtractor) {
        List<String> value = request == null ? null : valueExtractor.apply(request);
        return value == null ? List.of() : value;
    }

    private static <R> int getIntOrZero(R request, Function<R, Integer> valueExtractor) {
        return RequestMapper.getIntOrDefault(request, valueExtractor, 0);
    }

    private static <R> int getIntOrDefault(R request, Function<R, Integer> valueExtractor, Integer defaultValue) {
        Integer value = request == null ? null : valueExtractor.apply(request);
        return value == null ? defaultValue : value;
    }

    public record CompleteUserTaskRequest(long userTaskKey, Map<String, Object> variables, String action) {
    }

    public record AssignUserTaskRequest(long userTaskKey, String assignee, String action, boolean allowOverride) {
    }

    public record FailJobRequest(long jobKey, int retries, String errorMessage, Long retryBackoff, Map<String, Object> variables) {
    }

    public record CompleteJobRequest(long jobKey, Map<String, Object> variables) {
    }

    public record DecisionEvaluationRequest(String decisionId, Long decisionKey, Map<String, Object> variables, String tenantId) {
    }

    public record BroadcastSignalRequest(String signalName, Map<String, Object> variables, String tenantId) {
    }

    public record UpdateJobRequest(long jobKey, JobServices.UpdateJobChangeset changeset) {
    }

    public record ErrorJobRequest(long jobKey, String errorCode, String errorMessage, Map<String, Object> variables) {
    }

    public record UpdateUserTaskRequest(long userTaskKey, UserTaskRecord changeset, String action) {
    }
}

