/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice(annotations={RestController.class})
public class GlobalControllerExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String REQUEST_BODY_MISSING_EXCEPTION_MESSAGE = "Required request body is missing";
    private static final String INVALID_ENUM_VALUE_EXCEPTION_MESSAGE = "Invalid Enum value";

    protected ProblemDetail createProblemDetail(Exception ex, HttpStatusCode status, String defaultDetail, String detailMessageCode, Object[] detailMessageArguments, WebRequest request) {
        String detail;
        if (this.isRequestBodyMissing(ex)) {
            detail = REQUEST_BODY_MISSING_EXCEPTION_MESSAGE;
        } else if (this.isUnknownEnumError(ex)) {
            HttpMessageNotReadableException httpMessageNotReadableException = (HttpMessageNotReadableException)ex;
            detail = Objects.requireNonNull(httpMessageNotReadableException.getRootCause()).getMessage();
        } else {
            detail = defaultDetail;
        }
        return super.createProblemDetail(ex, status, detail, detailMessageCode, detailMessageArguments, request);
    }

    private boolean isRequestBodyMissing(Exception ex) {
        HttpMessageNotReadableException exception;
        String exceptionMessage;
        return ex instanceof HttpMessageNotReadableException && (exceptionMessage = (exception = (HttpMessageNotReadableException)ex).getMessage()) != null && exceptionMessage.startsWith(REQUEST_BODY_MISSING_EXCEPTION_MESSAGE);
    }

    private boolean isUnknownEnumError(Exception ex) {
        if (ex instanceof HttpMessageNotReadableException) {
            HttpMessageNotReadableException exception = (HttpMessageNotReadableException)ex;
            String exceptionMessage = exception.getMessage();
            return exceptionMessage != null && exceptionMessage.contains(INVALID_ENUM_VALUE_EXCEPTION_MESSAGE);
        }
        return false;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ProblemDetail> handleAllExceptions(Exception ex, HttpServletRequest request) {
        ProblemDetail problemDetail = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, (String)ex.getMessage());
        problemDetail.setInstance(URI.create(request.getRequestURI()));
        return ResponseEntity.of((ProblemDetail)problemDetail).build();
    }
}

