/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserTaskItem {
    private Long key;
    private String state;
    private String assignee;
    private String elementId;
    private Long elementInstanceKey;
    @Valid
    private List<String> candidateGroup = new ArrayList<String>();
    @Valid
    private List<String> candidateUser = new ArrayList<String>();
    private String processDefinitionId;
    private Long processDefinitionKey;
    private Long processInstanceKey;
    private Long formKey;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String creationDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String completionDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String followUpDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String dueDate;
    private String tenantIds;
    private String externalFormReference;
    private Integer processDefinitionVersion;
    @Valid
    private Map<String, String> customHeaders = new HashMap<String, String>();
    private Integer priority = 50;

    public UserTaskItem key(Long key) {
        this.key = key;
        return this;
    }

    @Schema(name="key", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="key")
    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public UserTaskItem state(String state) {
        this.state = state;
        return this;
    }

    @Schema(name="state", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public UserTaskItem assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Schema(name="assignee", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="assignee")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public UserTaskItem elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    @Schema(name="elementId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="elementId")
    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public UserTaskItem elementInstanceKey(Long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    @Schema(name="elementInstanceKey", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="elementInstanceKey")
    public Long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(Long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public UserTaskItem candidateGroup(List<String> candidateGroup) {
        this.candidateGroup = candidateGroup;
        return this;
    }

    public UserTaskItem addCandidateGroupItem(String candidateGroupItem) {
        if (this.candidateGroup == null) {
            this.candidateGroup = new ArrayList<String>();
        }
        this.candidateGroup.add(candidateGroupItem);
        return this;
    }

    @Schema(name="candidateGroup", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="candidateGroup")
    public List<String> getCandidateGroup() {
        return this.candidateGroup;
    }

    public void setCandidateGroup(List<String> candidateGroup) {
        this.candidateGroup = candidateGroup;
    }

    public UserTaskItem candidateUser(List<String> candidateUser) {
        this.candidateUser = candidateUser;
        return this;
    }

    public UserTaskItem addCandidateUserItem(String candidateUserItem) {
        if (this.candidateUser == null) {
            this.candidateUser = new ArrayList<String>();
        }
        this.candidateUser.add(candidateUserItem);
        return this;
    }

    @Schema(name="candidateUser", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="candidateUser")
    public List<String> getCandidateUser() {
        return this.candidateUser;
    }

    public void setCandidateUser(List<String> candidateUser) {
        this.candidateUser = candidateUser;
    }

    public UserTaskItem processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Schema(name="processDefinitionId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionId")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public UserTaskItem processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Schema(name="processDefinitionKey", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionKey")
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public UserTaskItem processInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Schema(name="processInstanceKey", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processInstanceKey")
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public UserTaskItem formKey(Long formKey) {
        this.formKey = formKey;
        return this;
    }

    @Schema(name="formKey", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="formKey")
    public Long getFormKey() {
        return this.formKey;
    }

    public void setFormKey(Long formKey) {
        this.formKey = formKey;
    }

    public UserTaskItem creationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Valid
    @Schema(name="creationDate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="creationDate")
    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public UserTaskItem completionDate(String completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Valid
    @Schema(name="completionDate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="completionDate")
    public String getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(String completionDate) {
        this.completionDate = completionDate;
    }

    public UserTaskItem followUpDate(String followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    @Valid
    @Schema(name="followUpDate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="followUpDate")
    public String getFollowUpDate() {
        return this.followUpDate;
    }

    public void setFollowUpDate(String followUpDate) {
        this.followUpDate = followUpDate;
    }

    public UserTaskItem dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Valid
    @Schema(name="dueDate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="dueDate")
    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public UserTaskItem tenantIds(String tenantIds) {
        this.tenantIds = tenantIds;
        return this;
    }

    @Schema(name="tenantIds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantIds")
    public String getTenantIds() {
        return this.tenantIds;
    }

    public void setTenantIds(String tenantIds) {
        this.tenantIds = tenantIds;
    }

    public UserTaskItem externalFormReference(String externalFormReference) {
        this.externalFormReference = externalFormReference;
        return this;
    }

    @Schema(name="externalFormReference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="externalFormReference")
    public String getExternalFormReference() {
        return this.externalFormReference;
    }

    public void setExternalFormReference(String externalFormReference) {
        this.externalFormReference = externalFormReference;
    }

    public UserTaskItem processDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Schema(name="processDefinitionVersion", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionVersion")
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public UserTaskItem customHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public UserTaskItem putCustomHeadersItem(String key, String customHeadersItem) {
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, String>();
        }
        this.customHeaders.put(key, customHeadersItem);
        return this;
    }

    @Schema(name="customHeaders", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="customHeaders")
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public UserTaskItem priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Min(value=0L)
    @Max(value=100L)
    @Schema(name="priority", description="The priority of a user task. The higher the value the higher the priority.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="priority")
    public @Min(value=0L) @Max(value=100L) Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTaskItem userTaskItem = (UserTaskItem)o;
        return Objects.equals(this.key, userTaskItem.key) && Objects.equals(this.state, userTaskItem.state) && Objects.equals(this.assignee, userTaskItem.assignee) && Objects.equals(this.elementId, userTaskItem.elementId) && Objects.equals(this.elementInstanceKey, userTaskItem.elementInstanceKey) && Objects.equals(this.candidateGroup, userTaskItem.candidateGroup) && Objects.equals(this.candidateUser, userTaskItem.candidateUser) && Objects.equals(this.processDefinitionId, userTaskItem.processDefinitionId) && Objects.equals(this.processDefinitionKey, userTaskItem.processDefinitionKey) && Objects.equals(this.processInstanceKey, userTaskItem.processInstanceKey) && Objects.equals(this.formKey, userTaskItem.formKey) && Objects.equals(this.creationDate, userTaskItem.creationDate) && Objects.equals(this.completionDate, userTaskItem.completionDate) && Objects.equals(this.followUpDate, userTaskItem.followUpDate) && Objects.equals(this.dueDate, userTaskItem.dueDate) && Objects.equals(this.tenantIds, userTaskItem.tenantIds) && Objects.equals(this.externalFormReference, userTaskItem.externalFormReference) && Objects.equals(this.processDefinitionVersion, userTaskItem.processDefinitionVersion) && Objects.equals(this.customHeaders, userTaskItem.customHeaders) && Objects.equals(this.priority, userTaskItem.priority);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.state, this.assignee, this.elementId, this.elementInstanceKey, this.candidateGroup, this.candidateUser, this.processDefinitionId, this.processDefinitionKey, this.processInstanceKey, this.formKey, this.creationDate, this.completionDate, this.followUpDate, this.dueDate, this.tenantIds, this.externalFormReference, this.processDefinitionVersion, this.customHeaders, this.priority);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserTaskItem {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    elementId: ").append(this.toIndentedString(this.elementId)).append("\n");
        sb.append("    elementInstanceKey: ").append(this.toIndentedString(this.elementInstanceKey)).append("\n");
        sb.append("    candidateGroup: ").append(this.toIndentedString(this.candidateGroup)).append("\n");
        sb.append("    candidateUser: ").append(this.toIndentedString(this.candidateUser)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    formKey: ").append(this.toIndentedString(this.formKey)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    followUpDate: ").append(this.toIndentedString(this.followUpDate)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    tenantIds: ").append(this.toIndentedString(this.tenantIds)).append("\n");
        sb.append("    externalFormReference: ").append(this.toIndentedString(this.externalFormReference)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    customHeaders: ").append(this.toIndentedString(this.customHeaders)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

