/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserTaskAssignmentRequest {
    private String assignee;
    private Boolean allowOverride = null;
    private String action = null;

    public UserTaskAssignmentRequest assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Schema(name="assignee", description="The assignee for the user task. The assignee must not be empty or `null`.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="assignee")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public UserTaskAssignmentRequest allowOverride(Boolean allowOverride) {
        this.allowOverride = allowOverride;
        return this;
    }

    @Schema(name="allowOverride", description="By default, the task is reassigned if it was already assigned. Set this to `false` to return an error in such cases. The task must then first be unassigned to be assigned again. Use this when you have users picking from group task queues to prevent race conditions. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="allowOverride")
    public Boolean getAllowOverride() {
        return this.allowOverride;
    }

    public void setAllowOverride(Boolean allowOverride) {
        this.allowOverride = allowOverride;
    }

    public UserTaskAssignmentRequest action(String action) {
        this.action = action;
        return this;
    }

    @Schema(name="action", description="A custom action value that will be accessible from user task events resulting from this endpoint invocation. If not provided, it will default to \"assign\". ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTaskAssignmentRequest userTaskAssignmentRequest = (UserTaskAssignmentRequest)o;
        return Objects.equals(this.assignee, userTaskAssignmentRequest.assignee) && Objects.equals(this.allowOverride, userTaskAssignmentRequest.allowOverride) && Objects.equals(this.action, userTaskAssignmentRequest.action);
    }

    public int hashCode() {
        return Objects.hash(this.assignee, this.allowOverride, this.action);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserTaskAssignmentRequest {\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    allowOverride: ").append(this.toIndentedString(this.allowOverride)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

