/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.BrokerInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="TopologyResponse", description="The response of a topology request.")
public class TopologyResponse {
    @Valid
    private @Valid List<@Valid BrokerInfo> brokers;
    private Integer clusterSize = null;
    private Integer partitionsCount = null;
    private Integer replicationFactor = null;
    private String gatewayVersion = null;

    public TopologyResponse brokers(List<@Valid BrokerInfo> brokers) {
        this.brokers = brokers;
        return this;
    }

    public TopologyResponse addBrokersItem(BrokerInfo brokersItem) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<BrokerInfo>();
        }
        this.brokers.add(brokersItem);
        return this;
    }

    @Valid
    @Schema(name="brokers", description="A list of brokers that are part of this cluster.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="brokers")
    public @Valid List<@Valid BrokerInfo> getBrokers() {
        return this.brokers;
    }

    public void setBrokers(List<@Valid BrokerInfo> brokers) {
        this.brokers = brokers;
    }

    public TopologyResponse clusterSize(Integer clusterSize) {
        this.clusterSize = clusterSize;
        return this;
    }

    @Schema(name="clusterSize", description="The number of brokers in the cluster.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="clusterSize")
    public Integer getClusterSize() {
        return this.clusterSize;
    }

    public void setClusterSize(Integer clusterSize) {
        this.clusterSize = clusterSize;
    }

    public TopologyResponse partitionsCount(Integer partitionsCount) {
        this.partitionsCount = partitionsCount;
        return this;
    }

    @Schema(name="partitionsCount", description="The number of partitions are spread across the cluster.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="partitionsCount")
    public Integer getPartitionsCount() {
        return this.partitionsCount;
    }

    public void setPartitionsCount(Integer partitionsCount) {
        this.partitionsCount = partitionsCount;
    }

    public TopologyResponse replicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    @Schema(name="replicationFactor", description="The configured replication factor for this cluster.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="replicationFactor")
    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public TopologyResponse gatewayVersion(String gatewayVersion) {
        this.gatewayVersion = gatewayVersion;
        return this;
    }

    @Schema(name="gatewayVersion", description="The version of the Zeebe Gateway.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="gatewayVersion")
    public String getGatewayVersion() {
        return this.gatewayVersion;
    }

    public void setGatewayVersion(String gatewayVersion) {
        this.gatewayVersion = gatewayVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyResponse topologyResponse = (TopologyResponse)o;
        return Objects.equals(this.brokers, topologyResponse.brokers) && Objects.equals(this.clusterSize, topologyResponse.clusterSize) && Objects.equals(this.partitionsCount, topologyResponse.partitionsCount) && Objects.equals(this.replicationFactor, topologyResponse.replicationFactor) && Objects.equals(this.gatewayVersion, topologyResponse.gatewayVersion);
    }

    public int hashCode() {
        return Objects.hash(this.brokers, this.clusterSize, this.partitionsCount, this.replicationFactor, this.gatewayVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TopologyResponse {\n");
        sb.append("    brokers: ").append(this.toIndentedString(this.brokers)).append("\n");
        sb.append("    clusterSize: ").append(this.toIndentedString(this.clusterSize)).append("\n");
        sb.append("    partitionsCount: ").append(this.toIndentedString(this.partitionsCount)).append("\n");
        sb.append("    replicationFactor: ").append(this.toIndentedString(this.replicationFactor)).append("\n");
        sb.append("    gatewayVersion: ").append(this.toIndentedString(this.gatewayVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

