/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SignalBroadcastRequest {
    private String signalName;
    @Valid
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String tenantId;

    public SignalBroadcastRequest() {
    }

    public SignalBroadcastRequest(String signalName) {
        this.signalName = signalName;
    }

    public SignalBroadcastRequest signalName(String signalName) {
        this.signalName = signalName;
        return this;
    }

    @NotNull
    @Schema(name="signalName", description="The name of the signal to broadcast.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="signalName")
    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public SignalBroadcastRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public SignalBroadcastRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Schema(name="variables", description="The signal variables as a JSON object.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public SignalBroadcastRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The ID of the tenant that owns the signal.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalBroadcastRequest signalBroadcastRequest = (SignalBroadcastRequest)o;
        return Objects.equals(this.signalName, signalBroadcastRequest.signalName) && Objects.equals(this.variables, signalBroadcastRequest.variables) && Objects.equals(this.tenantId, signalBroadcastRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.signalName, this.variables, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalBroadcastRequest {\n");
        sb.append("    signalName: ").append(this.toIndentedString(this.signalName)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

