/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SetVariableRequest {
    @Valid
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Boolean local = false;
    private Long operationReference;

    public SetVariableRequest() {
    }

    public SetVariableRequest(Map<String, Object> variables) {
        this.variables = variables;
    }

    public SetVariableRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public SetVariableRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @NotNull
    @Schema(name="variables", description="JSON object representing the variables to set in the element\u2019s scope.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public SetVariableRequest local(Boolean local) {
        this.local = local;
        return this;
    }

    @Schema(name="local", description="If set to true, the variables are merged strictly into the local scope (as specified by the `elementInstanceKey`). Otherwise, the variables are propagated to upper scopes and set at the outermost one.  Let\u2019s consider the following example:  There are two scopes '1' and '2'. Scope '1' is the parent scope of '2'. The effective variables of the scopes are: 1 => { \"foo\" : 2 } 2 => { \"bar\" : 1 }  An update request with elementInstanceKey as '2', variables { \"foo\" : 5 }, and local set to true leaves scope '1' unchanged and adjusts scope '2' to { \"bar\" : 1, \"foo\" 5 }.  By default, with local set to false, scope '1' will be { \"foo\": 5 } and scope '2' will be { \"bar\" : 1 }. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="local")
    public Boolean getLocal() {
        return this.local;
    }

    public void setLocal(Boolean local) {
        this.local = local;
    }

    public SetVariableRequest operationReference(Long operationReference) {
        this.operationReference = operationReference;
        return this;
    }

    @Min(value=1L)
    @Schema(name="operationReference", description="A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="operationReference")
    public @Min(value=1L) Long getOperationReference() {
        return this.operationReference;
    }

    public void setOperationReference(Long operationReference) {
        this.operationReference = operationReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetVariableRequest setVariableRequest = (SetVariableRequest)o;
        return Objects.equals(this.variables, setVariableRequest.variables) && Objects.equals(this.local, setVariableRequest.local) && Objects.equals(this.operationReference, setVariableRequest.operationReference);
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.local, this.operationReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetVariableRequest {\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    local: ").append(this.toIndentedString(this.local)).append("\n");
        sb.append("    operationReference: ").append(this.toIndentedString(this.operationReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

