/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.gateway.protocol.rest.OperationItem;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceReferenceItem;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProcessInstanceItem {
    private Long key;
    private String processDefinitionName;
    private Integer processDefinitionVersion;
    private String bpmnProcessId;
    private Long parentKey;
    private Long parentFlowNodeInstanceKey;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String startDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String endDate;
    private StateEnum state;
    private Boolean incident;
    private Boolean hasActiveOperation;
    private Long processDefinitionKey;
    private String tenantId;
    private String rootInstanceId;
    @Valid
    private @Valid List<@Valid OperationItem> operations = new ArrayList<OperationItem>();
    @Valid
    private @Valid List<@Valid ProcessInstanceReferenceItem> callHierarchy = new ArrayList<ProcessInstanceReferenceItem>();

    public ProcessInstanceItem key(Long key) {
        this.key = key;
        return this;
    }

    @Schema(name="key", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="key")
    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public ProcessInstanceItem processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Schema(name="processDefinitionName", description="The process name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionName")
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public ProcessInstanceItem processDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Schema(name="processDefinitionVersion", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionVersion")
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public ProcessInstanceItem bpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    @Schema(name="bpmnProcessId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="bpmnProcessId")
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public ProcessInstanceItem parentKey(Long parentKey) {
        this.parentKey = parentKey;
        return this;
    }

    @Schema(name="parentKey", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="parentKey")
    public Long getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(Long parentKey) {
        this.parentKey = parentKey;
    }

    public ProcessInstanceItem parentFlowNodeInstanceKey(Long parentFlowNodeInstanceKey) {
        this.parentFlowNodeInstanceKey = parentFlowNodeInstanceKey;
        return this;
    }

    @Schema(name="parentFlowNodeInstanceKey", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="parentFlowNodeInstanceKey")
    public Long getParentFlowNodeInstanceKey() {
        return this.parentFlowNodeInstanceKey;
    }

    public void setParentFlowNodeInstanceKey(Long parentFlowNodeInstanceKey) {
        this.parentFlowNodeInstanceKey = parentFlowNodeInstanceKey;
    }

    public ProcessInstanceItem startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Valid
    @Schema(name="startDate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startDate")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public ProcessInstanceItem endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Valid
    @Schema(name="endDate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="endDate")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public ProcessInstanceItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Schema(name="state", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public ProcessInstanceItem incident(Boolean incident) {
        this.incident = incident;
        return this;
    }

    @Schema(name="incident", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="incident")
    public Boolean getIncident() {
        return this.incident;
    }

    public void setIncident(Boolean incident) {
        this.incident = incident;
    }

    public ProcessInstanceItem hasActiveOperation(Boolean hasActiveOperation) {
        this.hasActiveOperation = hasActiveOperation;
        return this;
    }

    @Schema(name="hasActiveOperation", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hasActiveOperation")
    public Boolean getHasActiveOperation() {
        return this.hasActiveOperation;
    }

    public void setHasActiveOperation(Boolean hasActiveOperation) {
        this.hasActiveOperation = hasActiveOperation;
    }

    public ProcessInstanceItem processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Schema(name="processDefinitionKey", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionKey")
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public ProcessInstanceItem tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public ProcessInstanceItem rootInstanceId(String rootInstanceId) {
        this.rootInstanceId = rootInstanceId;
        return this;
    }

    @Schema(name="rootInstanceId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="rootInstanceId")
    public String getRootInstanceId() {
        return this.rootInstanceId;
    }

    public void setRootInstanceId(String rootInstanceId) {
        this.rootInstanceId = rootInstanceId;
    }

    public ProcessInstanceItem operations(List<@Valid OperationItem> operations) {
        this.operations = operations;
        return this;
    }

    public ProcessInstanceItem addOperationsItem(OperationItem operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<OperationItem>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Valid
    @Schema(name="operations", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="operations")
    public @Valid List<@Valid OperationItem> getOperations() {
        return this.operations;
    }

    public void setOperations(List<@Valid OperationItem> operations) {
        this.operations = operations;
    }

    public ProcessInstanceItem callHierarchy(List<@Valid ProcessInstanceReferenceItem> callHierarchy) {
        this.callHierarchy = callHierarchy;
        return this;
    }

    public ProcessInstanceItem addCallHierarchyItem(ProcessInstanceReferenceItem callHierarchyItem) {
        if (this.callHierarchy == null) {
            this.callHierarchy = new ArrayList<ProcessInstanceReferenceItem>();
        }
        this.callHierarchy.add(callHierarchyItem);
        return this;
    }

    @Valid
    @Schema(name="callHierarchy", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="callHierarchy")
    public @Valid List<@Valid ProcessInstanceReferenceItem> getCallHierarchy() {
        return this.callHierarchy;
    }

    public void setCallHierarchy(List<@Valid ProcessInstanceReferenceItem> callHierarchy) {
        this.callHierarchy = callHierarchy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceItem processInstanceItem = (ProcessInstanceItem)o;
        return Objects.equals(this.key, processInstanceItem.key) && Objects.equals(this.processDefinitionName, processInstanceItem.processDefinitionName) && Objects.equals(this.processDefinitionVersion, processInstanceItem.processDefinitionVersion) && Objects.equals(this.bpmnProcessId, processInstanceItem.bpmnProcessId) && Objects.equals(this.parentKey, processInstanceItem.parentKey) && Objects.equals(this.parentFlowNodeInstanceKey, processInstanceItem.parentFlowNodeInstanceKey) && Objects.equals(this.startDate, processInstanceItem.startDate) && Objects.equals(this.endDate, processInstanceItem.endDate) && Objects.equals((Object)this.state, (Object)processInstanceItem.state) && Objects.equals(this.incident, processInstanceItem.incident) && Objects.equals(this.hasActiveOperation, processInstanceItem.hasActiveOperation) && Objects.equals(this.processDefinitionKey, processInstanceItem.processDefinitionKey) && Objects.equals(this.tenantId, processInstanceItem.tenantId) && Objects.equals(this.rootInstanceId, processInstanceItem.rootInstanceId) && Objects.equals(this.operations, processInstanceItem.operations) && Objects.equals(this.callHierarchy, processInstanceItem.callHierarchy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.processDefinitionName, this.processDefinitionVersion, this.bpmnProcessId, this.parentKey, this.parentFlowNodeInstanceKey, this.startDate, this.endDate, this.state, this.incident, this.hasActiveOperation, this.processDefinitionKey, this.tenantId, this.rootInstanceId, this.operations, this.callHierarchy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceItem {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    processDefinitionName: ").append(this.toIndentedString(this.processDefinitionName)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    bpmnProcessId: ").append(this.toIndentedString(this.bpmnProcessId)).append("\n");
        sb.append("    parentKey: ").append(this.toIndentedString(this.parentKey)).append("\n");
        sb.append("    parentFlowNodeInstanceKey: ").append(this.toIndentedString(this.parentFlowNodeInstanceKey)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    incident: ").append(this.toIndentedString(this.incident)).append("\n");
        sb.append("    hasActiveOperation: ").append(this.toIndentedString(this.hasActiveOperation)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    rootInstanceId: ").append(this.toIndentedString(this.rootInstanceId)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    callHierarchy: ").append(this.toIndentedString(this.callHierarchy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        ACTIVE("ACTIVE"),
        INCIDENT("INCIDENT"),
        COMPLETED("COMPLETED"),
        CANCELED("CANCELED"),
        UNKNOWN("UNKNOWN"),
        UNSPECIFIED("UNSPECIFIED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

