/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceVariableFilterRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProcessInstanceFilterRequest {
    private Boolean running;
    private Boolean active;
    private Boolean incidents;
    private Boolean finished;
    private Boolean completed;
    private Boolean canceled;
    private Boolean retriesLeft;
    private String errorMessage;
    private String activityId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String startDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String endDate;
    private String bpmnProcessId;
    private Integer processDefinitionVersion;
    private ProcessInstanceVariableFilterRequest variable;
    private String batchOperationId;
    private Long parentProcessInstanceKey;
    private String tenantId;

    public ProcessInstanceFilterRequest running(Boolean running) {
        this.running = running;
        return this;
    }

    @Schema(name="running", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="running")
    public Boolean getRunning() {
        return this.running;
    }

    public void setRunning(Boolean running) {
        this.running = running;
    }

    public ProcessInstanceFilterRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @Schema(name="active", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ProcessInstanceFilterRequest incidents(Boolean incidents) {
        this.incidents = incidents;
        return this;
    }

    @Schema(name="incidents", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="incidents")
    public Boolean getIncidents() {
        return this.incidents;
    }

    public void setIncidents(Boolean incidents) {
        this.incidents = incidents;
    }

    public ProcessInstanceFilterRequest finished(Boolean finished) {
        this.finished = finished;
        return this;
    }

    @Schema(name="finished", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="finished")
    public Boolean getFinished() {
        return this.finished;
    }

    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    public ProcessInstanceFilterRequest completed(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @Schema(name="completed", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="completed")
    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public ProcessInstanceFilterRequest canceled(Boolean canceled) {
        this.canceled = canceled;
        return this;
    }

    @Schema(name="canceled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="canceled")
    public Boolean getCanceled() {
        return this.canceled;
    }

    public void setCanceled(Boolean canceled) {
        this.canceled = canceled;
    }

    public ProcessInstanceFilterRequest retriesLeft(Boolean retriesLeft) {
        this.retriesLeft = retriesLeft;
        return this;
    }

    @Schema(name="retriesLeft", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="retriesLeft")
    public Boolean getRetriesLeft() {
        return this.retriesLeft;
    }

    public void setRetriesLeft(Boolean retriesLeft) {
        this.retriesLeft = retriesLeft;
    }

    public ProcessInstanceFilterRequest errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Schema(name="errorMessage", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ProcessInstanceFilterRequest activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Schema(name="activityId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="activityId")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public ProcessInstanceFilterRequest startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Valid
    @Schema(name="startDate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startDate")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public ProcessInstanceFilterRequest endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Valid
    @Schema(name="endDate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="endDate")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public ProcessInstanceFilterRequest bpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    @Schema(name="bpmnProcessId", description="The bpmn process ID.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="bpmnProcessId")
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public ProcessInstanceFilterRequest processDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Schema(name="processDefinitionVersion", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processDefinitionVersion")
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public ProcessInstanceFilterRequest variable(ProcessInstanceVariableFilterRequest variable) {
        this.variable = variable;
        return this;
    }

    @Valid
    @Schema(name="variable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variable")
    public ProcessInstanceVariableFilterRequest getVariable() {
        return this.variable;
    }

    public void setVariable(ProcessInstanceVariableFilterRequest variable) {
        this.variable = variable;
    }

    public ProcessInstanceFilterRequest batchOperationId(String batchOperationId) {
        this.batchOperationId = batchOperationId;
        return this;
    }

    @Schema(name="batchOperationId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="batchOperationId")
    public String getBatchOperationId() {
        return this.batchOperationId;
    }

    public void setBatchOperationId(String batchOperationId) {
        this.batchOperationId = batchOperationId;
    }

    public ProcessInstanceFilterRequest parentProcessInstanceKey(Long parentProcessInstanceKey) {
        this.parentProcessInstanceKey = parentProcessInstanceKey;
        return this;
    }

    @Schema(name="parentProcessInstanceKey", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="parentProcessInstanceKey")
    public Long getParentProcessInstanceKey() {
        return this.parentProcessInstanceKey;
    }

    public void setParentProcessInstanceKey(Long parentProcessInstanceKey) {
        this.parentProcessInstanceKey = parentProcessInstanceKey;
    }

    public ProcessInstanceFilterRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceFilterRequest processInstanceFilterRequest = (ProcessInstanceFilterRequest)o;
        return Objects.equals(this.running, processInstanceFilterRequest.running) && Objects.equals(this.active, processInstanceFilterRequest.active) && Objects.equals(this.incidents, processInstanceFilterRequest.incidents) && Objects.equals(this.finished, processInstanceFilterRequest.finished) && Objects.equals(this.completed, processInstanceFilterRequest.completed) && Objects.equals(this.canceled, processInstanceFilterRequest.canceled) && Objects.equals(this.retriesLeft, processInstanceFilterRequest.retriesLeft) && Objects.equals(this.errorMessage, processInstanceFilterRequest.errorMessage) && Objects.equals(this.activityId, processInstanceFilterRequest.activityId) && Objects.equals(this.startDate, processInstanceFilterRequest.startDate) && Objects.equals(this.endDate, processInstanceFilterRequest.endDate) && Objects.equals(this.bpmnProcessId, processInstanceFilterRequest.bpmnProcessId) && Objects.equals(this.processDefinitionVersion, processInstanceFilterRequest.processDefinitionVersion) && Objects.equals(this.variable, processInstanceFilterRequest.variable) && Objects.equals(this.batchOperationId, processInstanceFilterRequest.batchOperationId) && Objects.equals(this.parentProcessInstanceKey, processInstanceFilterRequest.parentProcessInstanceKey) && Objects.equals(this.tenantId, processInstanceFilterRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.running, this.active, this.incidents, this.finished, this.completed, this.canceled, this.retriesLeft, this.errorMessage, this.activityId, this.startDate, this.endDate, this.bpmnProcessId, this.processDefinitionVersion, this.variable, this.batchOperationId, this.parentProcessInstanceKey, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceFilterRequest {\n");
        sb.append("    running: ").append(this.toIndentedString(this.running)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    incidents: ").append(this.toIndentedString(this.incidents)).append("\n");
        sb.append("    finished: ").append(this.toIndentedString(this.finished)).append("\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    canceled: ").append(this.toIndentedString(this.canceled)).append("\n");
        sb.append("    retriesLeft: ").append(this.toIndentedString(this.retriesLeft)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    bpmnProcessId: ").append(this.toIndentedString(this.bpmnProcessId)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    variable: ").append(this.toIndentedString(this.variable)).append("\n");
        sb.append("    batchOperationId: ").append(this.toIndentedString(this.batchOperationId)).append("\n");
        sb.append("    parentProcessInstanceKey: ").append(this.toIndentedString(this.parentProcessInstanceKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

