/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="OperationItem", description=" Operation")
public class OperationItem {
    private String id;
    private String batchOperationId;
    private TypeEnum type;
    private StateEnum state;
    private String errorMessage;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String completedDate;

    public OperationItem id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OperationItem batchOperationId(String batchOperationId) {
        this.batchOperationId = batchOperationId;
        return this;
    }

    @Schema(name="batchOperationId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="batchOperationId")
    public String getBatchOperationId() {
        return this.batchOperationId;
    }

    public void setBatchOperationId(String batchOperationId) {
        this.batchOperationId = batchOperationId;
    }

    public OperationItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OperationItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Schema(name="state", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public OperationItem errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Schema(name="errorMessage", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public OperationItem completedDate(String completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    @Valid
    @Schema(name="completedDate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="completedDate")
    public String getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(String completedDate) {
        this.completedDate = completedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationItem operationItem = (OperationItem)o;
        return Objects.equals(this.id, operationItem.id) && Objects.equals(this.batchOperationId, operationItem.batchOperationId) && Objects.equals((Object)this.type, (Object)operationItem.type) && Objects.equals((Object)this.state, (Object)operationItem.state) && Objects.equals(this.errorMessage, operationItem.errorMessage) && Objects.equals(this.completedDate, operationItem.completedDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.batchOperationId, this.type, this.state, this.errorMessage, this.completedDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    batchOperationId: ").append(this.toIndentedString(this.batchOperationId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    completedDate: ").append(this.toIndentedString(this.completedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        RESOLVE_INCIDENT("RESOLVE_INCIDENT"),
        CANCEL_PROCESS_INSTANCE("CANCEL_PROCESS_INSTANCE"),
        DELETE_PROCESS_INSTANCE("DELETE_PROCESS_INSTANCE"),
        ADD_VARIABLE("ADD_VARIABLE"),
        UPDATE_VARIABLE("UPDATE_VARIABLE"),
        MODIFY_PROCESS_INSTANCE("MODIFY_PROCESS_INSTANCE"),
        DELETE_DECISION_DEFINITION("DELETE_DECISION_DEFINITION"),
        DELETE_PROCESS_DEFINITION("DELETE_PROCESS_DEFINITION"),
        MIGRATE_PROCESS_INSTANCE("MIGRATE_PROCESS_INSTANCE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StateEnum {
        SCHEDULED("SCHEDULED"),
        LOCKED("LOCKED"),
        SENT("SENT"),
        FAILED("FAILED"),
        COMPLETED("COMPLETED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

