/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="ModifyProcessInstanceVariableInstruction", description="Instructions describing which variables should be created.")
public class ModifyProcessInstanceVariableInstruction {
    @Valid
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String scopeId = "";

    public ModifyProcessInstanceVariableInstruction() {
    }

    public ModifyProcessInstanceVariableInstruction(Map<String, Object> variables) {
        this.variables = variables;
    }

    public ModifyProcessInstanceVariableInstruction variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public ModifyProcessInstanceVariableInstruction putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @NotNull
    @Schema(name="variables", description="JSON document that will instantiate the variables for the root variable scope of the process instance. It must be a JSON object, as variables will be mapped in a key-value fashion. ", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public ModifyProcessInstanceVariableInstruction scopeId(String scopeId) {
        this.scopeId = scopeId;
        return this;
    }

    @Schema(name="scopeId", description="The ID of the element in which scope the variables should be created. Leave empty to create the variables in the global scope of the process instance ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="scopeId")
    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyProcessInstanceVariableInstruction modifyProcessInstanceVariableInstruction = (ModifyProcessInstanceVariableInstruction)o;
        return Objects.equals(this.variables, modifyProcessInstanceVariableInstruction.variables) && Objects.equals(this.scopeId, modifyProcessInstanceVariableInstruction.scopeId);
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.scopeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModifyProcessInstanceVariableInstruction {\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    scopeId: ").append(this.toIndentedString(this.scopeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

