/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="ModifyProcessInstanceTerminateInstruction", description="Instructions describing which elements should be terminated.")
public class ModifyProcessInstanceTerminateInstruction {
    private Long elementInstanceKey;

    public ModifyProcessInstanceTerminateInstruction() {
    }

    public ModifyProcessInstanceTerminateInstruction(Long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public ModifyProcessInstanceTerminateInstruction elementInstanceKey(Long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    @NotNull
    @Schema(name="elementInstanceKey", description="The ID of the element that should be terminated.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="elementInstanceKey")
    public Long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(Long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyProcessInstanceTerminateInstruction modifyProcessInstanceTerminateInstruction = (ModifyProcessInstanceTerminateInstruction)o;
        return Objects.equals(this.elementInstanceKey, modifyProcessInstanceTerminateInstruction.elementInstanceKey);
    }

    public int hashCode() {
        return Objects.hash(this.elementInstanceKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModifyProcessInstanceTerminateInstruction {\n");
        sb.append("    elementInstanceKey: ").append(this.toIndentedString(this.elementInstanceKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

