/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceActivateInstruction;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceTerminateInstruction;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ModifyProcessInstanceRequest {
    @Valid
    private @Valid List<@Valid ModifyProcessInstanceActivateInstruction> activateInstructions = new ArrayList<ModifyProcessInstanceActivateInstruction>();
    @Valid
    private @Valid List<@Valid ModifyProcessInstanceTerminateInstruction> terminateInstructions = new ArrayList<ModifyProcessInstanceTerminateInstruction>();
    private Long operationReference;

    public ModifyProcessInstanceRequest activateInstructions(List<@Valid ModifyProcessInstanceActivateInstruction> activateInstructions) {
        this.activateInstructions = activateInstructions;
        return this;
    }

    public ModifyProcessInstanceRequest addActivateInstructionsItem(ModifyProcessInstanceActivateInstruction activateInstructionsItem) {
        if (this.activateInstructions == null) {
            this.activateInstructions = new ArrayList<ModifyProcessInstanceActivateInstruction>();
        }
        this.activateInstructions.add(activateInstructionsItem);
        return this;
    }

    @Valid
    @Schema(name="activateInstructions", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="activateInstructions")
    public @Valid List<@Valid ModifyProcessInstanceActivateInstruction> getActivateInstructions() {
        return this.activateInstructions;
    }

    public void setActivateInstructions(List<@Valid ModifyProcessInstanceActivateInstruction> activateInstructions) {
        this.activateInstructions = activateInstructions;
    }

    public ModifyProcessInstanceRequest terminateInstructions(List<@Valid ModifyProcessInstanceTerminateInstruction> terminateInstructions) {
        this.terminateInstructions = terminateInstructions;
        return this;
    }

    public ModifyProcessInstanceRequest addTerminateInstructionsItem(ModifyProcessInstanceTerminateInstruction terminateInstructionsItem) {
        if (this.terminateInstructions == null) {
            this.terminateInstructions = new ArrayList<ModifyProcessInstanceTerminateInstruction>();
        }
        this.terminateInstructions.add(terminateInstructionsItem);
        return this;
    }

    @Valid
    @Schema(name="terminateInstructions", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="terminateInstructions")
    public @Valid List<@Valid ModifyProcessInstanceTerminateInstruction> getTerminateInstructions() {
        return this.terminateInstructions;
    }

    public void setTerminateInstructions(List<@Valid ModifyProcessInstanceTerminateInstruction> terminateInstructions) {
        this.terminateInstructions = terminateInstructions;
    }

    public ModifyProcessInstanceRequest operationReference(Long operationReference) {
        this.operationReference = operationReference;
        return this;
    }

    @Min(value=1L)
    @Schema(name="operationReference", description="A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="operationReference")
    public @Min(value=1L) Long getOperationReference() {
        return this.operationReference;
    }

    public void setOperationReference(Long operationReference) {
        this.operationReference = operationReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyProcessInstanceRequest modifyProcessInstanceRequest = (ModifyProcessInstanceRequest)o;
        return Objects.equals(this.activateInstructions, modifyProcessInstanceRequest.activateInstructions) && Objects.equals(this.terminateInstructions, modifyProcessInstanceRequest.terminateInstructions) && Objects.equals(this.operationReference, modifyProcessInstanceRequest.operationReference);
    }

    public int hashCode() {
        return Objects.hash(this.activateInstructions, this.terminateInstructions, this.operationReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModifyProcessInstanceRequest {\n");
        sb.append("    activateInstructions: ").append(this.toIndentedString(this.activateInstructions)).append("\n");
        sb.append("    terminateInstructions: ").append(this.toIndentedString(this.terminateInstructions)).append("\n");
        sb.append("    operationReference: ").append(this.toIndentedString(this.operationReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

