/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceVariableInstruction;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="ModifyProcessInstanceActivateInstruction", description="Instructions describing which elements should be activated in which scopes and which variables should be created. ")
public class ModifyProcessInstanceActivateInstruction {
    private String elementId;
    private Long ancestorElementInstanceKey = -1L;
    @Valid
    private @Valid List<@Valid ModifyProcessInstanceVariableInstruction> variableInstructions = new ArrayList<ModifyProcessInstanceVariableInstruction>();

    public ModifyProcessInstanceActivateInstruction() {
    }

    public ModifyProcessInstanceActivateInstruction(String elementId) {
        this.elementId = elementId;
    }

    public ModifyProcessInstanceActivateInstruction elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    @NotNull
    @Schema(name="elementId", description="The ID of the element that should be activated.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="elementId")
    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public ModifyProcessInstanceActivateInstruction ancestorElementInstanceKey(Long ancestorElementInstanceKey) {
        this.ancestorElementInstanceKey = ancestorElementInstanceKey;
        return this;
    }

    @Schema(name="ancestorElementInstanceKey", description="The key of the ancestor scope the element instance should be created in. Set to -1 to create the new element instance within an existing element instance of the flow scope. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="ancestorElementInstanceKey")
    public Long getAncestorElementInstanceKey() {
        return this.ancestorElementInstanceKey;
    }

    public void setAncestorElementInstanceKey(Long ancestorElementInstanceKey) {
        this.ancestorElementInstanceKey = ancestorElementInstanceKey;
    }

    public ModifyProcessInstanceActivateInstruction variableInstructions(List<@Valid ModifyProcessInstanceVariableInstruction> variableInstructions) {
        this.variableInstructions = variableInstructions;
        return this;
    }

    public ModifyProcessInstanceActivateInstruction addVariableInstructionsItem(ModifyProcessInstanceVariableInstruction variableInstructionsItem) {
        if (this.variableInstructions == null) {
            this.variableInstructions = new ArrayList<ModifyProcessInstanceVariableInstruction>();
        }
        this.variableInstructions.add(variableInstructionsItem);
        return this;
    }

    @Valid
    @Schema(name="variableInstructions", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variableInstructions")
    public @Valid List<@Valid ModifyProcessInstanceVariableInstruction> getVariableInstructions() {
        return this.variableInstructions;
    }

    public void setVariableInstructions(List<@Valid ModifyProcessInstanceVariableInstruction> variableInstructions) {
        this.variableInstructions = variableInstructions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyProcessInstanceActivateInstruction modifyProcessInstanceActivateInstruction = (ModifyProcessInstanceActivateInstruction)o;
        return Objects.equals(this.elementId, modifyProcessInstanceActivateInstruction.elementId) && Objects.equals(this.ancestorElementInstanceKey, modifyProcessInstanceActivateInstruction.ancestorElementInstanceKey) && Objects.equals(this.variableInstructions, modifyProcessInstanceActivateInstruction.variableInstructions);
    }

    public int hashCode() {
        return Objects.hash(this.elementId, this.ancestorElementInstanceKey, this.variableInstructions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModifyProcessInstanceActivateInstruction {\n");
        sb.append("    elementId: ").append(this.toIndentedString(this.elementId)).append("\n");
        sb.append("    ancestorElementInstanceKey: ").append(this.toIndentedString(this.ancestorElementInstanceKey)).append("\n");
        sb.append("    variableInstructions: ").append(this.toIndentedString(this.variableInstructions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

