/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.MigrateProcessInstanceMappingInstruction;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MigrateProcessInstanceRequest {
    private Long targetProcessDefinitionKey;
    @Valid
    private @Valid List<@Valid MigrateProcessInstanceMappingInstruction> mappingInstructions = new ArrayList<MigrateProcessInstanceMappingInstruction>();
    private Long operationReference;

    public MigrateProcessInstanceRequest() {
    }

    public MigrateProcessInstanceRequest(Long targetProcessDefinitionKey, List<@Valid MigrateProcessInstanceMappingInstruction> mappingInstructions) {
        this.targetProcessDefinitionKey = targetProcessDefinitionKey;
        this.mappingInstructions = mappingInstructions;
    }

    public MigrateProcessInstanceRequest targetProcessDefinitionKey(Long targetProcessDefinitionKey) {
        this.targetProcessDefinitionKey = targetProcessDefinitionKey;
        return this;
    }

    @NotNull
    @Schema(name="targetProcessDefinitionKey", description="The key of process definition to migrate the process instance to.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="targetProcessDefinitionKey")
    public Long getTargetProcessDefinitionKey() {
        return this.targetProcessDefinitionKey;
    }

    public void setTargetProcessDefinitionKey(Long targetProcessDefinitionKey) {
        this.targetProcessDefinitionKey = targetProcessDefinitionKey;
    }

    public MigrateProcessInstanceRequest mappingInstructions(List<@Valid MigrateProcessInstanceMappingInstruction> mappingInstructions) {
        this.mappingInstructions = mappingInstructions;
        return this;
    }

    public MigrateProcessInstanceRequest addMappingInstructionsItem(MigrateProcessInstanceMappingInstruction mappingInstructionsItem) {
        if (this.mappingInstructions == null) {
            this.mappingInstructions = new ArrayList<MigrateProcessInstanceMappingInstruction>();
        }
        this.mappingInstructions.add(mappingInstructionsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="mappingInstructions", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="mappingInstructions")
    public @NotNull @Valid List<@Valid MigrateProcessInstanceMappingInstruction> getMappingInstructions() {
        return this.mappingInstructions;
    }

    public void setMappingInstructions(List<@Valid MigrateProcessInstanceMappingInstruction> mappingInstructions) {
        this.mappingInstructions = mappingInstructions;
    }

    public MigrateProcessInstanceRequest operationReference(Long operationReference) {
        this.operationReference = operationReference;
        return this;
    }

    @Min(value=1L)
    @Schema(name="operationReference", description="A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="operationReference")
    public @Min(value=1L) Long getOperationReference() {
        return this.operationReference;
    }

    public void setOperationReference(Long operationReference) {
        this.operationReference = operationReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrateProcessInstanceRequest migrateProcessInstanceRequest = (MigrateProcessInstanceRequest)o;
        return Objects.equals(this.targetProcessDefinitionKey, migrateProcessInstanceRequest.targetProcessDefinitionKey) && Objects.equals(this.mappingInstructions, migrateProcessInstanceRequest.mappingInstructions) && Objects.equals(this.operationReference, migrateProcessInstanceRequest.operationReference);
    }

    public int hashCode() {
        return Objects.hash(this.targetProcessDefinitionKey, this.mappingInstructions, this.operationReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrateProcessInstanceRequest {\n");
        sb.append("    targetProcessDefinitionKey: ").append(this.toIndentedString(this.targetProcessDefinitionKey)).append("\n");
        sb.append("    mappingInstructions: ").append(this.toIndentedString(this.mappingInstructions)).append("\n");
        sb.append("    operationReference: ").append(this.toIndentedString(this.operationReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

