/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="MigrateProcessInstanceMappingInstruction", description="The mapping instructions describe how to map elements from the source process definition to the target process definition. ")
public class MigrateProcessInstanceMappingInstruction {
    private String sourceElementId;
    private String targetElementId;

    public MigrateProcessInstanceMappingInstruction() {
    }

    public MigrateProcessInstanceMappingInstruction(String sourceElementId, String targetElementId) {
        this.sourceElementId = sourceElementId;
        this.targetElementId = targetElementId;
    }

    public MigrateProcessInstanceMappingInstruction sourceElementId(String sourceElementId) {
        this.sourceElementId = sourceElementId;
        return this;
    }

    @NotNull
    @Schema(name="sourceElementId", description="The element ID to migrate from.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="sourceElementId")
    public String getSourceElementId() {
        return this.sourceElementId;
    }

    public void setSourceElementId(String sourceElementId) {
        this.sourceElementId = sourceElementId;
    }

    public MigrateProcessInstanceMappingInstruction targetElementId(String targetElementId) {
        this.targetElementId = targetElementId;
        return this;
    }

    @NotNull
    @Schema(name="targetElementId", description="The element ID to migrate into.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="targetElementId")
    public String getTargetElementId() {
        return this.targetElementId;
    }

    public void setTargetElementId(String targetElementId) {
        this.targetElementId = targetElementId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrateProcessInstanceMappingInstruction migrateProcessInstanceMappingInstruction = (MigrateProcessInstanceMappingInstruction)o;
        return Objects.equals(this.sourceElementId, migrateProcessInstanceMappingInstruction.sourceElementId) && Objects.equals(this.targetElementId, migrateProcessInstanceMappingInstruction.targetElementId);
    }

    public int hashCode() {
        return Objects.hash(this.sourceElementId, this.targetElementId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrateProcessInstanceMappingInstruction {\n");
        sb.append("    sourceElementId: ").append(this.toIndentedString(this.sourceElementId)).append("\n");
        sb.append("    targetElementId: ").append(this.toIndentedString(this.targetElementId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

