/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessagePublicationRequest {
    private String name;
    private String correlationKey = "";
    private Long timeToLive = 0L;
    private String messageId = null;
    @Valid
    private Map<String, Object> variables;
    private String tenantId = null;

    public MessagePublicationRequest() {
    }

    public MessagePublicationRequest(String name, String correlationKey) {
        this.name = name;
        this.correlationKey = correlationKey;
    }

    public MessagePublicationRequest name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", description="The name of the message.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessagePublicationRequest correlationKey(String correlationKey) {
        this.correlationKey = correlationKey;
        return this;
    }

    @NotNull
    @Schema(name="correlationKey", description="The correlation key of the message.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="correlationKey")
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public MessagePublicationRequest timeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    @Schema(name="timeToLive", description="Timespan (in ms) to buffer the message on the broker.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="timeToLive")
    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public MessagePublicationRequest messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @Schema(name="messageId", description="The unique ID of the message. Only useful to ensure only one message with the given ID will ever be published (during its lifetime). ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public MessagePublicationRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public MessagePublicationRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Schema(name="variables", description="The message variables as JSON document.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public MessagePublicationRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant of the message sender.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagePublicationRequest messagePublicationRequest = (MessagePublicationRequest)o;
        return Objects.equals(this.name, messagePublicationRequest.name) && Objects.equals(this.correlationKey, messagePublicationRequest.correlationKey) && Objects.equals(this.timeToLive, messagePublicationRequest.timeToLive) && Objects.equals(this.messageId, messagePublicationRequest.messageId) && Objects.equals(this.variables, messagePublicationRequest.variables) && Objects.equals(this.tenantId, messagePublicationRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.correlationKey, this.timeToLive, this.messageId, this.variables, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagePublicationRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    correlationKey: ").append(this.toIndentedString(this.correlationKey)).append("\n");
        sb.append("    timeToLive: ").append(this.toIndentedString(this.timeToLive)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

