/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="MessageCorrelationResponse", description="The message key of the correlated message, as well as the first process instance key it correlated with. ")
public class MessageCorrelationResponse {
    private Long messageKey;
    private String tenantId;
    private Long processInstanceKey;

    public MessageCorrelationResponse messageKey(Long messageKey) {
        this.messageKey = messageKey;
        return this;
    }

    @Schema(name="messageKey", description="The key of the correlated message", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="messageKey")
    public Long getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(Long messageKey) {
        this.messageKey = messageKey;
    }

    public MessageCorrelationResponse tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="The tenant ID of the correlated message", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public MessageCorrelationResponse processInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Schema(name="processInstanceKey", description="The key of the first process instance the message correlated with", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processInstanceKey")
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageCorrelationResponse messageCorrelationResponse = (MessageCorrelationResponse)o;
        return Objects.equals(this.messageKey, messageCorrelationResponse.messageKey) && Objects.equals(this.tenantId, messageCorrelationResponse.tenantId) && Objects.equals(this.processInstanceKey, messageCorrelationResponse.processInstanceKey);
    }

    public int hashCode() {
        return Objects.hash(this.messageKey, this.tenantId, this.processInstanceKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageCorrelationResponse {\n");
        sb.append("    messageKey: ").append(this.toIndentedString(this.messageKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

