/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageCorrelationRequest {
    private String name;
    private String correlationKey = "";
    @Valid
    private Map<String, Object> variables;
    private String tenantId = null;

    public MessageCorrelationRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="The message name as defined in the BPMN process ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessageCorrelationRequest correlationKey(String correlationKey) {
        this.correlationKey = correlationKey;
        return this;
    }

    @Schema(name="correlationKey", description="The correlation key of the message", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="correlationKey")
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public MessageCorrelationRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public MessageCorrelationRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Schema(name="variables", description="The message variables as JSON document", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public MessageCorrelationRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="tenantId", description="the tenant for which the message is published", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageCorrelationRequest messageCorrelationRequest = (MessageCorrelationRequest)o;
        return Objects.equals(this.name, messageCorrelationRequest.name) && Objects.equals(this.correlationKey, messageCorrelationRequest.correlationKey) && Objects.equals(this.variables, messageCorrelationRequest.variables) && Objects.equals(this.tenantId, messageCorrelationRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.correlationKey, this.variables, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageCorrelationRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    correlationKey: ").append(this.toIndentedString(this.correlationKey)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

