/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.gateway.protocol.rest.EvaluatedDecisionOutputItem;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="MatchedDecisionRuleItem", description="The decision rules that matched within this decision evaluation.")
public class MatchedDecisionRuleItem {
    private String ruleId;
    private Integer ruleIndex;
    @Valid
    private @Valid List<@Valid EvaluatedDecisionOutputItem> evaluatedOutputs = new ArrayList<EvaluatedDecisionOutputItem>();

    public MatchedDecisionRuleItem ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @Schema(name="ruleId", description="The ID of the matched rule.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="ruleId")
    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public MatchedDecisionRuleItem ruleIndex(Integer ruleIndex) {
        this.ruleIndex = ruleIndex;
        return this;
    }

    @Schema(name="ruleIndex", description="The index of the matched rule.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="ruleIndex")
    public Integer getRuleIndex() {
        return this.ruleIndex;
    }

    public void setRuleIndex(Integer ruleIndex) {
        this.ruleIndex = ruleIndex;
    }

    public MatchedDecisionRuleItem evaluatedOutputs(List<@Valid EvaluatedDecisionOutputItem> evaluatedOutputs) {
        this.evaluatedOutputs = evaluatedOutputs;
        return this;
    }

    public MatchedDecisionRuleItem addEvaluatedOutputsItem(EvaluatedDecisionOutputItem evaluatedOutputsItem) {
        if (this.evaluatedOutputs == null) {
            this.evaluatedOutputs = new ArrayList<EvaluatedDecisionOutputItem>();
        }
        this.evaluatedOutputs.add(evaluatedOutputsItem);
        return this;
    }

    @Valid
    @Schema(name="evaluatedOutputs", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="evaluatedOutputs")
    public @Valid List<@Valid EvaluatedDecisionOutputItem> getEvaluatedOutputs() {
        return this.evaluatedOutputs;
    }

    public void setEvaluatedOutputs(List<@Valid EvaluatedDecisionOutputItem> evaluatedOutputs) {
        this.evaluatedOutputs = evaluatedOutputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchedDecisionRuleItem matchedDecisionRuleItem = (MatchedDecisionRuleItem)o;
        return Objects.equals(this.ruleId, matchedDecisionRuleItem.ruleId) && Objects.equals(this.ruleIndex, matchedDecisionRuleItem.ruleIndex) && Objects.equals(this.evaluatedOutputs, matchedDecisionRuleItem.evaluatedOutputs);
    }

    public int hashCode() {
        return Objects.hash(this.ruleId, this.ruleIndex, this.evaluatedOutputs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchedDecisionRuleItem {\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("    ruleIndex: ").append(this.toIndentedString(this.ruleIndex)).append("\n");
        sb.append("    evaluatedOutputs: ").append(this.toIndentedString(this.evaluatedOutputs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

