/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobFailRequest {
    private Integer retries = 0;
    private String errorMessage = null;
    private Long retryBackOff = 0L;
    @Valid
    private Map<String, Object> variables;

    public JobFailRequest retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Schema(name="retries", description="The amount of retries the job should have left ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="retries")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public JobFailRequest errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Schema(name="errorMessage", description="An optional message describing why the job failed. This is particularly useful if a job runs out of retries and an incident is raised, as this message can help explain why an incident was raised. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public JobFailRequest retryBackOff(Long retryBackOff) {
        this.retryBackOff = retryBackOff;
        return this;
    }

    @Schema(name="retryBackOff", description="The backoff timeout (in ms) for the next retry. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="retryBackOff")
    public Long getRetryBackOff() {
        return this.retryBackOff;
    }

    public void setRetryBackOff(Long retryBackOff) {
        this.retryBackOff = retryBackOff;
    }

    public JobFailRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public JobFailRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Schema(name="variables", description="JSON object that will instantiate the variables at the local scope of the job's associated task. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobFailRequest jobFailRequest = (JobFailRequest)o;
        return Objects.equals(this.retries, jobFailRequest.retries) && Objects.equals(this.errorMessage, jobFailRequest.errorMessage) && Objects.equals(this.retryBackOff, jobFailRequest.retryBackOff) && Objects.equals(this.variables, jobFailRequest.variables);
    }

    public int hashCode() {
        return Objects.hash(this.retries, this.errorMessage, this.retryBackOff, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobFailRequest {\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    retryBackOff: ").append(this.toIndentedString(this.retryBackOff)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

