/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobErrorRequest {
    private String errorCode;
    private String errorMessage = null;
    @Valid
    private Map<String, Object> variables;

    public JobErrorRequest() {
    }

    public JobErrorRequest(String errorCode) {
        this.errorCode = errorCode;
    }

    public JobErrorRequest errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @NotNull
    @Schema(name="errorCode", description="The error code that will be matched with an error catch event. ", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public JobErrorRequest errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Schema(name="errorMessage", description="An error message that provides additional context. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public JobErrorRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public JobErrorRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Schema(name="variables", description="JSON object that will instantiate the variables at the local scope of the error catch event that catches the thrown error. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobErrorRequest jobErrorRequest = (JobErrorRequest)o;
        return Objects.equals(this.errorCode, jobErrorRequest.errorCode) && Objects.equals(this.errorMessage, jobErrorRequest.errorMessage) && Objects.equals(this.variables, jobErrorRequest.variables);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.errorMessage, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobErrorRequest {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

