/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="JobChangeset", description="JSON object with changed job attribute values.  The following attributes can be adjusted with this endpoint, additional attributes will be ignored:  * `retries` - The new amount of retries for the job; must be a positive number. * `timeout` - The duration of the new timeout in ms, starting from the current moment.  Providing any of those attributes with a null value or omitting it preserves the persisted attribute\u2019s value.  The job cannot be completed or failed with this endpoint, use the complete job or fail job endpoints instead. ")
public class JobChangeset {
    private Integer retries = null;
    private Long timeout = null;

    public JobChangeset retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Schema(name="retries", description="The new amount of retries for the job; must be a positive number.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="retries")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public JobChangeset timeout(Long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Schema(name="timeout", description="The duration of the new timeout in ms, starting from the current moment.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="timeout")
    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobChangeset jobChangeset = (JobChangeset)o;
        return Objects.equals(this.retries, jobChangeset.retries) && Objects.equals(this.timeout, jobChangeset.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.retries, this.timeout);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobChangeset {\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

